/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.item.CurrencyTooltipData;
import com.nyfaria.numismaticoverhaul.owostuff.ops.ItemOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CurrencyTooltipComponent
implements ClientTooltipComponent {
    private final CurrencyTooltipData data;
    private final List<Component> text;
    private int widthCache = -1;

    public CurrencyTooltipComponent(CurrencyTooltipData data) {
        this.data = data;
        this.text = new ArrayList<Component>();
        if (data.original()[0] != -1L) {
            CurrencyConverter.getAsItemStackList(data.original()).forEach(stack -> this.text.add(CurrencyTooltipComponent.createPlaceholder(stack.m_41613_())));
            this.text.add(Component.m_130674_((String)" "));
        }
        CurrencyConverter.getAsItemStackList(data.value()).forEach(stack -> this.text.add(CurrencyTooltipComponent.createPlaceholder(stack.m_41613_())));
    }

    public int m_142103_() {
        return 10 * this.text.size();
    }

    public int m_142069_(Font textRenderer) {
        if (this.widthCache == -1) {
            this.widthCache = textRenderer.m_92852_((FormattedText)this.text.stream().max(Comparator.comparingInt(arg_0 -> ((Font)textRenderer).m_92852_(arg_0))).orElse(Component.m_130674_((String)"")));
        }
        return this.widthCache;
    }

    public void m_142440_(Font textRenderer, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource immediate) {
        for (int i = 0; i < this.text.size(); ++i) {
            textRenderer.m_92841_(this.text.get(i), (float)x, (float)(y + i * 10), -1, true, matrix4f, (MultiBufferSource)immediate, false, 0, 0xF000F0);
        }
    }

    public void m_183452_(Font textRenderer, int x, int y, PoseStack matrices, ItemRenderer itemRenderer, int z) {
        int i;
        List<Object> originalCoins = this.data.original()[0] != -1L ? CurrencyConverter.getAsItemStackList(this.data.original()) : new ArrayList();
        List<ItemStack> coins = CurrencyConverter.getAsItemStackList(this.data.value());
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/gui/container/villager2.png"));
        for (i = 0; i < originalCoins.size(); ++i) {
            GuiComponent.m_93143_((PoseStack)matrices, (int)(x + (((ItemStack)originalCoins.get(i)).m_41613_() > 9 ? 14 : 11)), (int)(y + 3), (int)z, (float)0.0f, (float)176.0f, (int)9, (int)2, (int)512, (int)256);
            itemRenderer.m_115123_(ItemOps.singleCopy((ItemStack)originalCoins.get(i)), x - 4, y - 5 + i * 10);
        }
        for (i = 0; i < coins.size(); ++i) {
            itemRenderer.m_115123_(ItemOps.singleCopy(coins.get(i)), x - 4, y - 5 + i * 10 + (originalCoins.size() == 0 ? 0 : 10 + originalCoins.size() * 10));
        }
    }

    private static Component createPlaceholder(int count) {
        String placeholder = "\u00a77   " + count + " ";
        return Component.m_237113_((String)placeholder).m_130940_(ChatFormatting.GRAY);
    }
}

