/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.block;

import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.block.ShopBlock;
import com.nyfaria.numismaticoverhaul.block.ShopMerchant;
import com.nyfaria.numismaticoverhaul.block.ShopOffer;
import com.nyfaria.numismaticoverhaul.block.ShopScreenHandler;
import com.nyfaria.numismaticoverhaul.init.BlockInit;
import com.nyfaria.numismaticoverhaul.owostuff.ops.WorldOps;
import com.nyfaria.numismaticoverhaul.owostuff.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends BlockEntity
implements ImplementedInventory,
WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private static final int[] NO_SLOTS = new int[0];
    private final NonNullList<ItemStack> INVENTORY = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final Merchant merchant;
    private final List<ShopOffer> offers;
    private long storedCurrency;
    private UUID owner;
    private boolean allowsTransfer = false;
    private int tradeIndex;

    public ShopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockInit.SHOP_BE.get(), pos, state);
        ShopBlock shop;
        Block block = state.m_60734_();
        boolean inexhaustible = block instanceof ShopBlock && (shop = (ShopBlock)block).inexhaustible();
        this.merchant = new ShopMerchant(this, inexhaustible);
        this.offers = new ArrayList<ShopOffer>();
        this.storedCurrency = 0L;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.INVENTORY;
    }

    public int[] m_7071_(Direction side) {
        return this.allowsTransfer ? SLOTS : NO_SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.allowsTransfer;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.numismaticoverhaul.shop.inventory_title");
    }

    @NotNull
    public Merchant getMerchant() {
        return this.merchant;
    }

    public List<ShopOffer> getOffers() {
        return this.offers;
    }

    public long getStoredCurrency() {
        return this.storedCurrency;
    }

    public boolean isTransferEnabled() {
        return this.allowsTransfer;
    }

    public void toggleTransfer() {
        this.allowsTransfer = !this.allowsTransfer;
    }

    public void setStoredCurrency(long storedCurrency) {
        this.storedCurrency = storedCurrency;
        this.m_6596_();
    }

    public void addCurrency(long value) {
        this.storedCurrency += value;
        this.m_6596_();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.INVENTORY);
        ShopOffer.writeAll(tag, this.offers);
        tag.m_128379_("AllowsTransfer", this.allowsTransfer);
        tag.m_128356_("StoredCurrency", this.storedCurrency);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.INVENTORY);
        ShopOffer.readAll(tag, this.offers);
        if (tag.m_128441_("Owner")) {
            this.owner = tag.m_128342_("Owner");
        }
        this.allowsTransfer = tag.m_128471_("AllowsTransfer");
        this.storedCurrency = tag.m_128454_("StoredCurrency");
    }

    public void addOrReplaceOffer(ShopOffer offer) {
        int indexToReplace = -1;
        for (int i = 0; i < this.offers.size(); ++i) {
            if (!ItemStack.m_41728_((ItemStack)offer.getSellStack(), (ItemStack)this.offers.get(i).getSellStack())) continue;
            indexToReplace = i;
            break;
        }
        if (indexToReplace == -1) {
            if (this.offers.size() >= 24) {
                NumismaticOverhaul.LOGGER.error("Tried adding more than 24 trades to shop at {}", (Object)this.f_58858_);
                return;
            }
            this.offers.add(offer);
        } else {
            this.offers.set(indexToReplace, offer);
        }
        this.m_6596_();
    }

    public void deleteOffer(ItemStack stack) {
        if (!this.offers.removeIf(offer -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)offer.getSellStack()))) {
            NumismaticOverhaul.LOGGER.error("Tried to delete invalid trade for {} from shop at {}", (Object)stack, (Object)this.f_58858_);
            return;
        }
        this.m_6596_();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ShopBlockEntity blockEntity) {
        blockEntity.tick();
    }

    public void tick() {
        if (this.f_58857_.m_46467_() % 60L == 0L) {
            ++this.tradeIndex;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemToRender() {
        if (this.tradeIndex > this.offers.size() - 1) {
            this.tradeIndex = 0;
        }
        return this.offers.get(this.tradeIndex).getSellStack();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new ShopScreenHandler(syncId, inv, this);
    }

    @Override
    public boolean m_6542_(Player player) {
        return player.m_20148_().equals(this.owner);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        tag.m_128473_("Items");
        tag.m_128473_("StoredCurrency");
        return tag;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        WorldOps.updateIfOnServer(this.f_58857_, this.f_58858_);
    }
}

