/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.block;

import com.nyfaria.numismaticoverhaul.block.ShopBlockEntity;
import com.nyfaria.numismaticoverhaul.block.ShopMerchant;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.init.BlockInit;
import com.nyfaria.numismaticoverhaul.network.NetworkHandler;
import com.nyfaria.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ShopBlock
extends BaseEntityBlock {
    private static final VoxelShape MAIN_PILLAR = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)14.0);
    private static final VoxelShape PLATE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape PILLAR_1 = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)3.0);
    private static final VoxelShape PILLAR_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)3.0);
    private static final VoxelShape PILLAR_3 = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0);
    private static final VoxelShape PILLAR_4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)MAIN_PILLAR, (VoxelShape[])new VoxelShape[]{PLATE, PILLAR_1, PILLAR_2, PILLAR_3, PILLAR_4});
    private final boolean inexhaustible;

    public ShopBlock(boolean inexhaustible) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_155954_(5.0f));
        this.inexhaustible = inexhaustible;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            ShopBlockEntity shop = (ShopBlockEntity)world.m_7702_(pos);
            if (shop.getOwner().equals(player.m_20148_())) {
                if (player.m_6144_()) {
                    return this.openShopMerchant(player, shop);
                }
                player.m_5893_(state.m_60750_(world, pos));
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateShopScreenS2CPacket(shop));
            } else {
                return this.openShopMerchant(player, shop);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult openShopMerchant(Player player, ShopBlockEntity shop) {
        if (shop.getMerchant().m_7962_() != null) {
            return InteractionResult.SUCCESS;
        }
        ((ShopMerchant)shop.getMerchant()).updateTrades();
        shop.getMerchant().m_7189_(player);
        shop.getMerchant().m_45301_(player, (Component)Component.m_237115_((String)"gui.numismaticoverhaul.shop.merchant_title"), 0);
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.f_46443_) {
            return;
        }
        if (!(placer instanceof ServerPlayer)) {
            world.m_46961_(pos, true);
            return;
        }
        ((ShopBlockEntity)world.m_7702_(pos)).setOwner(placer.m_20148_());
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ShopBlockEntity) {
                ShopBlockEntity shop = (ShopBlockEntity)blockEntity;
                CurrencyConverter.getAsValidStacks(shop.getStoredCurrency()).forEach(stack -> Containers.m_18992_((Level)shop.m_58904_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)shop);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public boolean inexhaustible() {
        return this.inexhaustible;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShopBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ShopBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockInit.SHOP_BE.get()), ShopBlockEntity::tick);
    }
}

