/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.ChatFormatting;
import net.minecraft.util.StringRepresentable;

public enum TentSize implements StringRepresentable
{
    TINY("tiny", ChatFormatting.RED),
    SMALL("small", ChatFormatting.BLUE),
    MEDIUM("medium", ChatFormatting.DARK_GREEN),
    LARGE("large", ChatFormatting.YELLOW),
    GIANT("giant", ChatFormatting.DARK_PURPLE),
    MEGA("mega", ChatFormatting.AQUA);

    public static final Codec<TentSize> CODEC;
    private final String name;
    private final ChatFormatting color;

    private TentSize(String name, ChatFormatting color) {
        this.name = name;
        this.color = color;
    }

    public static DataResult<TentSize> getByName(String id) {
        for (TentSize t : TentSize.values()) {
            if (!t.m_7912_().equals(id)) continue;
            return DataResult.success((Object)((Object)t));
        }
        return DataResult.error((String)("Failed to parse tent size '" + id + "'"));
    }

    public String m_7912_() {
        return this.name;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    static {
        CODEC = Codec.STRING.comapFlatMap(TentSize::getByName, TentSize::m_7912_).stable();
    }
}

