/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.NTRegistry;
import nomadictents.NomadicTents;
import nomadictents.block.IndluWallBlock;
import nomadictents.block.TentDoorBlock;
import nomadictents.block.YurtRoofBlock;
import nomadictents.block.YurtWallBlock;
import nomadictents.dimension.DynamicDimensionHelper;
import nomadictents.structure.LocStructureProcessor;
import nomadictents.structure.ShamiyanaStructureProcessor;
import nomadictents.structure.TepeeStructureProcessor;
import nomadictents.tileentity.TentDoorBlockEntity;
import nomadictents.util.Tent;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public final class TentPlacer {
    public static final Direction TENT_DIRECTION = Direction.EAST;
    public static final int TENT_Y = 64;
    private static final String MODID = "nomadictents";
    private static TentPlacer instance;
    public static final Map<TentSize, Map<TentType, Supplier<Block>>> DOORS;
    public static final Map<ResourceLocation, Function<Boolean, BlockState>> FRAME_TO_BLOCK;
    public static final Map<ResourceLocation, RegistryObject<Block>> BLOCK_TO_FRAME;
    public static final Map<DyeColor, Supplier<Block>> SHAMIYANA_WALLS;
    public static final Map<DyeColor, ShamiyanaStructureProcessor> SHAMIYANA_PROCESSORS;
    private final RuleTest barrierTest;
    private final RuleTest tentBlockTest;
    private final RuleProcessor removeBarrierProcessor;
    private final RuleProcessor removeTentBlockProcessor;
    private final RuleProcessor frameBlockProcessor;
    private final RuleProcessor insideTentProcessor;
    private final Map<TentSize, Map<TentType, Set<BlockPos>>> templatePositions = new EnumMap<TentSize, Map<TentType, Set<BlockPos>>>(TentSize.class);

    public TentPlacer() {
        TagKey tentWallTag = BlockTags.create((ResourceLocation)new ResourceLocation(MODID, "tent/tent_wall"));
        this.barrierTest = new BlockMatchTest(Blocks.f_50375_);
        this.tentBlockTest = new TagMatchTest(tentWallTag);
        this.removeBarrierProcessor = new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule(this.barrierTest, (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50016_.m_49966_())));
        this.removeTentBlockProcessor = new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule(this.tentBlockTest, (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50016_.m_49966_())));
        ImmutableList.Builder frameBlocksBuilder = new ImmutableList.Builder();
        for (Map.Entry<ResourceLocation, RegistryObject<Block>> entry : BLOCK_TO_FRAME.entrySet()) {
            Block tentBlock = (Block)ForgeRegistries.BLOCKS.getValue(entry.getKey());
            if (tentBlock == null) continue;
            frameBlocksBuilder.add((Object)new ProcessorRule((RuleTest)new BlockMatchTest(tentBlock), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)entry.getValue().get()).m_49966_()));
        }
        this.frameBlockProcessor = new RuleProcessor((List)frameBlocksBuilder.build());
        this.insideTentProcessor = new RuleProcessor((List)new ImmutableList.Builder().add((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)NTRegistry.YURT_WALL.get()), (RuleTest)AlwaysTrueTest.f_73954_, (BlockState)((Block)NTRegistry.YURT_WALL.get()).m_49966_().m_61124_((Property)YurtWallBlock.OUTSIDE, (Comparable)Boolean.valueOf(false)))).add((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)NTRegistry.YURT_ROOF.get()), (RuleTest)AlwaysTrueTest.f_73954_, (BlockState)((Block)NTRegistry.YURT_ROOF.get()).m_49966_().m_61124_((Property)YurtRoofBlock.OUTSIDE, (Comparable)Boolean.valueOf(false)))).add((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)NTRegistry.INDLU_WALL.get()), (RuleTest)AlwaysTrueTest.f_73954_, (BlockState)((Block)NTRegistry.INDLU_WALL.get()).m_49966_().m_61124_((Property)IndluWallBlock.OUTSIDE, (Comparable)Boolean.valueOf(false)))).build());
    }

    public static TentPlacer getInstance() {
        if (null == instance) {
            instance = new TentPlacer();
        }
        return instance;
    }

    public static TentSize getOverworldSize(TentSize original) {
        if (((Boolean)NomadicTents.CONFIG.USE_ACTUAL_SIZE.get()).booleanValue()) {
            return original;
        }
        if (original == TentSize.TINY || original == TentSize.SMALL || original == TentSize.MEDIUM) {
            return TentSize.TINY;
        }
        return TentSize.SMALL;
    }

    public boolean canPlaceTentFrame(Level level, BlockPos door, TentType type, TentSize size, Direction direction) {
        TentSize useSize = TentPlacer.getOverworldSize(size);
        StructureTemplate template = TentPlacer.getTemplate(level, type, useSize);
        if (null == template) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        Set<BlockPos> tentBlocks = this.getTentBlockPositions(level, door, type, useSize);
        for (BlockPos pos : tentBlocks) {
            BlockPos checkPos = origin.m_121955_((Vec3i)pos.m_7954_(rotation));
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_60767_().m_76336_() || checkState.m_60713_((Block)NTRegistry.DOOR_FRAME.get())) continue;
            return false;
        }
        return true;
    }

    public boolean placeOrUpgradeTent(Level level, BlockPos door, Tent tent, ServerLevel sourceLevel, Vec3 sourceVec, float sourceRot) {
        BlockEntity blockEntity;
        boolean rebuildPlatform;
        BlockEntity blockEntity2;
        boolean tentExists = level.m_8055_(door).m_60734_() instanceof TentDoorBlock;
        Tent prevTent = tent;
        if (tentExists && (blockEntity2 = level.m_7702_(door)) instanceof TentDoorBlockEntity) {
            TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity2;
            prevTent = tentDoor.getTent();
        }
        boolean rebuildTent = prevTent.getSize() != tent.getSize() || prevTent.getColor() != tent.getColor();
        boolean bl = rebuildPlatform = prevTent.getSize() != tent.getSize() || prevTent.getLayers() != tent.getLayers();
        if (rebuildTent) {
            this.removeTent(level, door, prevTent.getType(), prevTent.getSize(), TENT_DIRECTION);
        }
        if (!tentExists || rebuildTent) {
            this.placeTent(level, door, tent.getType(), tent.getSize(), TENT_DIRECTION, tent.getColor());
        }
        if (!tentExists) {
            this.placePlatform(level, door, tent.getType(), tent.getSize(), tent.getLayers(), true);
        }
        if (tentExists && rebuildPlatform) {
            this.upgradePlatform(level, door, tent.getType(), prevTent.getSize(), tent.getSize(), prevTent.getLayers(), tent.getLayers());
        }
        if (!tentExists && ((Boolean)NomadicTents.CONFIG.TENT_DECOR_BUILD.get()).booleanValue() || rebuildTent && ((Boolean)NomadicTents.CONFIG.TENT_DECOR_UPGRADE.get()).booleanValue()) {
            this.placeTentDecor(level, door, tent.getType(), tent.getSize(), TENT_DIRECTION);
        }
        if ((blockEntity = level.m_7702_(door)) instanceof TentDoorBlockEntity) {
            TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity;
            tentDoor.setSpawnpoint((Level)sourceLevel, sourceVec);
            tentDoor.setSpawnRot(sourceRot);
            tentDoor.setTent(tent);
        }
        return true;
    }

    public boolean placeTentFrameWithDoor(Level level, BlockPos door, Tent tent, Direction direction, @Nullable Player owner) {
        BlockEntity blockEntity;
        boolean success = this.placeTentFrame(level, door, tent.getType(), tent.getSize(), direction);
        if (success && (blockEntity = level.m_7702_(door)) instanceof TentDoorBlockEntity) {
            TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity;
            tentDoor.setTent(tent);
            tentDoor.setDirection(direction);
            if (owner != null) {
                tentDoor.setOwner(owner.m_20148_());
            }
        }
        return success;
    }

    public boolean placeTent(Level level, BlockPos door, TentType type, TentSize size, Direction direction, @Nullable DyeColor color) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StructureTemplate template = TentPlacer.getTemplate(level, type, size);
        if (null == template) {
            return false;
        }
        BlockState doorState = TentPlacer.getDoor(type, size, direction);
        if (null == doorState) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        RandomSource rand = RandomSource.m_216335_((long)(door.hashCode() + level.m_46472_().m_135782_().hashCode()));
        BoundingBox mbb = BoundingBox.m_162375_((Vec3i)origin.m_121996_(template.m_163801_()), (Vec3i)origin.m_121955_(template.m_163801_()));
        StructurePlaceSettings placement = new StructurePlaceSettings().m_74379_(rotation).m_230324_(rand).m_74381_(mbb).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)TepeeStructureProcessor.TEPEE_PROCESSOR).m_74383_((StructureProcessor)this.insideTentProcessor);
        if (color != null) {
            placement.m_74383_((StructureProcessor)SHAMIYANA_PROCESSORS.get(color));
        }
        if (!template.m_230328_((ServerLevelAccessor)serverLevel, origin, origin, placement, rand, 3)) {
            return false;
        }
        level.m_7731_(door, doorState, 3);
        return true;
    }

    public boolean placeTentDecor(Level level, BlockPos door, TentType type, TentSize size, Direction direction) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StructureTemplate template = TentPlacer.getDecorTemplate(level, type, size);
        if (null == template) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        RandomSource rand = RandomSource.m_216335_((long)door.hashCode());
        BoundingBox mbb = BoundingBox.m_162375_((Vec3i)origin.m_121996_(template.m_163801_()), (Vec3i)origin.m_121955_(template.m_163801_()));
        StructurePlaceSettings placement = new StructurePlaceSettings().m_74379_(rotation).m_230324_(rand).m_74381_(mbb).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)this.removeBarrierProcessor).m_74383_((StructureProcessor)LocStructureProcessor.REPLACE_AIR);
        return template.m_230328_((ServerLevelAccessor)serverLevel, origin, origin, placement, rand, 3);
    }

    public boolean placeTentFrame(Level level, BlockPos door, TentType type, TentSize size, Direction direction) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TentSize useSize = TentPlacer.getOverworldSize(size);
        StructureTemplate template = TentPlacer.getTemplate(level, type, useSize);
        if (null == template) {
            return false;
        }
        BlockState doorState = TentPlacer.getDoor(type, size, direction);
        if (null == doorState) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        RandomSource rand = RandomSource.m_216335_((long)door.hashCode());
        BoundingBox mbb = BoundingBox.m_162375_((Vec3i)origin.m_121996_(template.m_163801_()), (Vec3i)origin.m_121955_(template.m_163801_()));
        StructurePlaceSettings placement = new StructurePlaceSettings().m_74379_(rotation).m_230324_(rand).m_74381_(mbb).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50375_))).m_74383_((StructureProcessor)this.frameBlockProcessor);
        if (!template.m_230328_((ServerLevelAccessor)serverLevel, origin, origin, placement, rand, 3)) {
            return false;
        }
        level.m_7731_(door, doorState, 3);
        return true;
    }

    public boolean isTent(Level level, BlockPos door, TentType type, TentSize size, Direction direction) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        StructureTemplate template = TentPlacer.getTemplate(level, type, size);
        if (null == template) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        Set<BlockPos> tentBlocks = this.getTentBlockPositions(level, door, type, size);
        TagKey tentWallTag = BlockTags.create((ResourceLocation)new ResourceLocation(MODID, "tent/tent_wall"));
        for (BlockPos pos : tentBlocks) {
            BlockPos checkPos = origin.m_121955_((Vec3i)pos.m_7954_(rotation));
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_204336_(tentWallTag) || checkState.m_60734_() instanceof TentDoorBlock) continue;
            return false;
        }
        return true;
    }

    public boolean removeTent(Level level, BlockPos door, TentType type, TentSize size, Direction direction) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StructureTemplate template = TentPlacer.getTemplate(level, type, size);
        if (null == template) {
            return false;
        }
        Rotation rotation = TentPlacer.toRotation(direction);
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        RandomSource rand = RandomSource.m_216335_((long)door.hashCode());
        BoundingBox mbb = BoundingBox.m_162375_((Vec3i)origin.m_121996_(template.m_163801_()), (Vec3i)origin.m_121955_(template.m_163801_()));
        StructurePlaceSettings placement = new StructurePlaceSettings().m_74379_(rotation).m_230324_(rand).m_74381_(mbb).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)this.removeBarrierProcessor).m_74383_((StructureProcessor)this.removeTentBlockProcessor);
        return template.m_230328_((ServerLevelAccessor)serverLevel, origin, origin, placement, rand, 3);
    }

    public boolean placePlatform(Level level, BlockPos door, TentType type, TentSize size, int layers, boolean fill) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        StructureTemplate template = TentPlacer.getTemplate(level, type, size);
        if (null == template) {
            return false;
        }
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, -1, -template.m_163801_().m_123343_() / 2));
        int width = template.m_163801_().m_123341_();
        BlockState rigidDirt = ((Block)NTRegistry.RIGID_DIRT.get()).m_49966_();
        BlockState dirt = NomadicTents.CONFIG.getFloorBlock().m_49966_();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                BlockState state;
                BlockPos p = origin.m_7918_(x, 0, z);
                boolean rigid = level.m_8055_(p.m_7494_()).m_60767_() == Material.f_76282_;
                BlockState blockState = state = rigid ? rigidDirt : dirt;
                if (rigid || fill) {
                    int l = layers + 1;
                    for (int y = 0; y < l; ++y) {
                        level.m_7731_(p.m_6625_(y), state, 3);
                    }
                }
                level.m_7731_(p.m_6625_(layers + 1), rigidDirt, 3);
            }
        }
        return true;
    }

    public boolean upgradePlatform(Level level, BlockPos door, TentType type, TentSize sizeOld, TentSize sizeNew, int layersOld, int layersNew) {
        int y;
        int l;
        BlockState state;
        int z;
        int x;
        BlockPos origin;
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        StructureTemplate templateOld = TentPlacer.getTemplate(level, type, sizeOld);
        StructureTemplate templateNew = TentPlacer.getTemplate(level, type, sizeNew);
        if (null == templateOld || null == templateNew) {
            return false;
        }
        int widthOld = templateOld.m_163801_().m_123341_();
        int widthNew = templateNew.m_163801_().m_123341_();
        int dwidth = (widthNew - widthOld) / 2;
        boolean upgradeSize = sizeOld != sizeNew;
        boolean upgradeLayers = layersOld != layersNew;
        BlockState rigidDirt = ((Block)NTRegistry.RIGID_DIRT.get()).m_49966_();
        BlockState dirt = NomadicTents.CONFIG.getFloorBlock().m_49966_();
        if (upgradeSize) {
            origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, -1, -templateNew.m_163801_().m_123343_() / 2));
            for (x = 0; x < widthNew; ++x) {
                for (z = 0; z < widthNew; ++z) {
                    BlockPos p = origin.m_7918_(x, 0, z);
                    if (z > dwidth && z < widthNew - dwidth && x < widthOld && !level.m_8055_(p).m_60713_(rigidDirt.m_60734_())) continue;
                    boolean rigid = level.m_8055_(p.m_7494_()).m_60767_() == Material.f_76282_;
                    state = rigid ? rigidDirt : dirt;
                    l = layersOld + 1;
                    for (y = 0; y < l; ++y) {
                        level.m_7731_(p.m_6625_(y), state, 3);
                    }
                    level.m_7731_(p.m_6625_(layersOld + 1), rigidDirt, 3);
                }
            }
        }
        if (upgradeLayers) {
            origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, -1, -templateNew.m_163801_().m_123343_() / 2));
            for (x = 0; x < widthNew; ++x) {
                for (z = 0; z < widthNew; ++z) {
                    BlockPos p = origin.m_7918_(x, 0, z);
                    boolean rigid = level.m_8055_(p.m_7494_()).m_60767_() == Material.f_76282_;
                    state = rigid ? rigidDirt : dirt;
                    l = layersNew + 1;
                    for (y = layersOld + 1; y < l; ++y) {
                        level.m_7731_(p.m_6625_(y), state, 3);
                    }
                    level.m_7731_(p.m_6625_(layersNew + 1), rigidDirt, 3);
                }
            }
        }
        return upgradeSize || upgradeLayers;
    }

    @Nullable
    public static StructureTemplate getTemplate(Level level, TentType type, TentSize size) {
        String templateName = "tent/" + size.m_7912_() + "_" + type.m_7912_();
        ResourceLocation templateId = new ResourceLocation(MODID, templateName);
        return TentPlacer.getTemplate(level, templateId);
    }

    @Nullable
    public static StructureTemplate getDecorTemplate(Level level, TentType type, TentSize size) {
        String templateName = "tent/decor/" + size.m_7912_() + "_" + type.m_7912_();
        ResourceLocation templateId = new ResourceLocation(MODID, templateName);
        return TentPlacer.getTemplate(level, templateId);
    }

    @Nullable
    public static StructureTemplate getTemplate(Level level, ResourceLocation templateId) {
        if (null == level.m_7654_()) {
            return null;
        }
        StructureTemplateManager templateManager = level.m_7654_().m_236738_();
        Optional template = templateManager.m_230407_(templateId);
        if (template.isEmpty()) {
            NomadicTents.LOGGER.warn("Failed to load tent template for " + templateId);
        }
        return template.orElse(null);
    }

    public Set<BlockPos> getTentBlockPositions(Level level, BlockPos door, TentType type, TentSize size) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return ImmutableSet.of();
        }
        if (this.templatePositions.containsKey((Object)size) && this.templatePositions.get((Object)size).containsKey((Object)type)) {
            return this.templatePositions.get((Object)size).get((Object)type);
        }
        StructureTemplate template = TentPlacer.getTemplate(level, type, size);
        if (null == template) {
            return ImmutableSet.of();
        }
        Rotation rotation = Rotation.NONE;
        BlockPos origin = door.m_121955_((Vec3i)BlockPos.f_121853_.m_7918_(0, 0, -template.m_163801_().m_123343_() / 2).m_7954_(rotation));
        StructurePlaceSettings placement = new StructurePlaceSettings().m_74379_(rotation);
        HashSet<BlockPos> tentBlocks = new HashSet<BlockPos>();
        TagKey tentWallTag = BlockTags.create((ResourceLocation)new ResourceLocation(MODID, "tent/tent_wall"));
        for (Block b : ForgeRegistries.BLOCKS.tags().getTag(tentWallTag)) {
            ObjectArrayList filtered = template.m_230335_(origin, placement, b, false);
            for (StructureTemplate.StructureBlockInfo blockInfo : filtered) {
                tentBlocks.add(blockInfo.f_74675_);
            }
        }
        this.templatePositions.computeIfAbsent(size, s -> new EnumMap(TentType.class)).put(type, ImmutableSet.copyOf(tentBlocks));
        return tentBlocks;
    }

    @Nullable
    public static BlockState getDoor(TentType type, TentSize size, Direction direction) {
        if (!DOORS.containsKey((Object)size)) {
            NomadicTents.LOGGER.warn("No tent door is registered for tent size " + size.m_7912_());
            return null;
        }
        Map<TentType, Supplier<Block>> doors = DOORS.get((Object)size);
        if (!doors.containsKey((Object)type)) {
            NomadicTents.LOGGER.warn("No tent door is registered for tent type " + size.m_7912_() + " " + type.m_7912_());
            return null;
        }
        BlockState doorState = doors.get((Object)type).get().m_49966_();
        doorState = (BlockState)doorState.m_61124_(TentDoorBlock.AXIS, (Comparable)direction.m_122434_());
        return doorState;
    }

    public static BlockState getFrameTarget(BlockState frame, Level level, BlockPos pos) {
        boolean outside;
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)frame.m_60734_());
        boolean bl = outside = !DynamicDimensionHelper.isInsideTent(level);
        if (FRAME_TO_BLOCK.containsKey(id)) {
            return FRAME_TO_BLOCK.get(id).apply(outside);
        }
        NomadicTents.LOGGER.warn("Failed to locate frame block target for " + id);
        return frame;
    }

    public static Rotation toRotation(Direction dir) {
        switch (dir) {
            default: {
                return Rotation.NONE;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case SOUTH: 
        }
        return Rotation.CLOCKWISE_90;
    }

    static {
        DOORS = new ImmutableMap.Builder().put((Object)TentSize.TINY, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tiny_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tiny_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tiny_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tiny_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tiny_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).put((Object)TentSize.SMALL, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "small_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "small_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "small_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "small_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "small_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).put((Object)TentSize.MEDIUM, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "medium_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "medium_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "medium_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "medium_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "medium_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).put((Object)TentSize.LARGE, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "large_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "large_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "large_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "large_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "large_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).put((Object)TentSize.GIANT, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "giant_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "giant_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "giant_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "giant_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "giant_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).put((Object)TentSize.MEGA, (Object)new ImmutableMap.Builder().put((Object)TentType.TEPEE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "mega_tepee_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.YURT, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "mega_yurt_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.BEDOUIN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "mega_bedouin_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.INDLU, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "mega_indlu_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)TentType.SHAMIYANA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "mega_shamiyana_door"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build()).build();
        FRAME_TO_BLOCK = new ImmutableMap.Builder().put((Object)new ResourceLocation(MODID, "yurt_wall_frame"), outside -> (BlockState)((Block)NTRegistry.YURT_WALL.get()).m_49966_().m_61124_((Property)YurtWallBlock.OUTSIDE, (Comparable)outside)).put((Object)new ResourceLocation(MODID, "yurt_roof_frame"), outside -> (BlockState)((Block)NTRegistry.YURT_ROOF.get()).m_49966_().m_61124_((Property)YurtRoofBlock.OUTSIDE, (Comparable)outside)).put((Object)new ResourceLocation(MODID, "tepee_wall_frame"), outside -> ((Block)NTRegistry.BLANK_TEPEE_WALL.get()).m_49966_()).put((Object)new ResourceLocation(MODID, "bedouin_wall_frame"), outside -> ((Block)NTRegistry.BEDOUIN_WALL.get()).m_49966_()).put((Object)new ResourceLocation(MODID, "bedouin_roof_frame"), outside -> ((Block)NTRegistry.BEDOUIN_ROOF.get()).m_49966_()).put((Object)new ResourceLocation(MODID, "indlu_wall_frame"), outside -> (BlockState)((Block)NTRegistry.INDLU_WALL.get()).m_49966_().m_61124_((Property)IndluWallBlock.OUTSIDE, (Comparable)outside)).put((Object)new ResourceLocation(MODID, "shamiyana_wall_frame"), outside -> ((Block)NTRegistry.WHITE_SHAMIYANA_WALL.get()).m_49966_()).build();
        BLOCK_TO_FRAME = new ImmutableMap.Builder().put((Object)new ResourceLocation(MODID, "yurt_wall"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "yurt_wall_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "yurt_roof"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "yurt_roof_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "blank_tepee_wall"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "tepee_wall_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "bedouin_wall"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "bedouin_wall_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "bedouin_roof"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "bedouin_roof_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "indlu_wall"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "indlu_wall_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)new ResourceLocation(MODID, "white_shamiyana_wall"), (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "shamiyana_wall_frame"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build();
        SHAMIYANA_WALLS = new ImmutableMap.Builder().put((Object)DyeColor.BLACK, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "black_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.BLUE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "blue_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.BROWN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "brown_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.CYAN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "cyan_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.GRAY, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "gray_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.GREEN, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "green_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.LIGHT_BLUE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "light_blue_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.LIGHT_GRAY, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "light_gray_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.LIME, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "lime_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.MAGENTA, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "magenta_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.ORANGE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "orange_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.PINK, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "pink_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.PURPLE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "purple_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.RED, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "red_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.WHITE, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "white_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).put((Object)DyeColor.YELLOW, (Object)RegistryObject.create((ResourceLocation)new ResourceLocation(MODID, "yellow_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS)).build();
        SHAMIYANA_PROCESSORS = new ImmutableMap.Builder().put((Object)DyeColor.BLACK, (Object)new ShamiyanaStructureProcessor(DyeColor.BLACK)).put((Object)DyeColor.BLUE, (Object)new ShamiyanaStructureProcessor(DyeColor.BLUE)).put((Object)DyeColor.BROWN, (Object)new ShamiyanaStructureProcessor(DyeColor.BROWN)).put((Object)DyeColor.CYAN, (Object)new ShamiyanaStructureProcessor(DyeColor.CYAN)).put((Object)DyeColor.GRAY, (Object)new ShamiyanaStructureProcessor(DyeColor.GRAY)).put((Object)DyeColor.GREEN, (Object)new ShamiyanaStructureProcessor(DyeColor.GREEN)).put((Object)DyeColor.LIGHT_BLUE, (Object)new ShamiyanaStructureProcessor(DyeColor.LIGHT_BLUE)).put((Object)DyeColor.LIGHT_GRAY, (Object)new ShamiyanaStructureProcessor(DyeColor.LIGHT_GRAY)).put((Object)DyeColor.LIME, (Object)new ShamiyanaStructureProcessor(DyeColor.LIME)).put((Object)DyeColor.MAGENTA, (Object)new ShamiyanaStructureProcessor(DyeColor.MAGENTA)).put((Object)DyeColor.ORANGE, (Object)new ShamiyanaStructureProcessor(DyeColor.ORANGE)).put((Object)DyeColor.PINK, (Object)new ShamiyanaStructureProcessor(DyeColor.PINK)).put((Object)DyeColor.PURPLE, (Object)new ShamiyanaStructureProcessor(DyeColor.PURPLE)).put((Object)DyeColor.RED, (Object)new ShamiyanaStructureProcessor(DyeColor.RED)).put((Object)DyeColor.WHITE, (Object)new ShamiyanaStructureProcessor(DyeColor.WHITE)).put((Object)DyeColor.YELLOW, (Object)new ShamiyanaStructureProcessor(DyeColor.YELLOW)).build();
    }
}

