/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import nomadictents.NTRegistry;
import nomadictents.item.TentItem;
import nomadictents.recipe.TentSizeRecipe;

public class TentLayerRecipe
extends ShapedRecipe {
    private final byte layer;

    public TentLayerRecipe(ResourceLocation recipeId, ItemStack outputItem, byte layer, int width, int height, NonNullList<Ingredient> recipeItemsIn) {
        super(recipeId, "tent_layer", width, height, recipeItemsIn, TentLayerRecipe.outputItemWithLayer(outputItem, layer));
        this.layer = layer;
    }

    private static ItemStack outputItemWithLayer(ItemStack itemStack, byte layer) {
        itemStack.m_41784_().m_128344_("layers", layer);
        return itemStack;
    }

    public boolean m_5818_(CraftingContainer craftingInventory, Level level) {
        ItemStack tent;
        if (super.m_5818_(craftingInventory, level) && !(tent = TentSizeRecipe.getStackMatching(craftingInventory, i -> i.m_41720_() instanceof TentItem)).m_41619_()) {
            return tent.m_41784_().m_128445_("layers") == this.layer - 1;
        }
        return false;
    }

    public ItemStack m_5874_(CraftingContainer craftingInventory) {
        ItemStack result = super.m_5874_(craftingInventory);
        ItemStack tent = TentSizeRecipe.getStackMatching(craftingInventory, i -> i.m_41720_() instanceof TentItem);
        if (!tent.m_41619_()) {
            CompoundTag tag = tent.m_41784_().m_6426_();
            tag.m_128344_("layers", this.layer);
            result.m_41751_(tag);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)NTRegistry.TENT_LAYER_RECIPE_SERIALIZER.get();
    }

    public byte getLayer() {
        return this.layer;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public static final String CATEGORY = "tent_layer";

        public ShapedRecipe m_6729_(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = super.m_6729_(recipeId, json);
            byte bLayer = 0;
            if (json.has("layer")) {
                bLayer = json.get("layer").getAsByte();
            }
            return new TentLayerRecipe(recipeId, recipe.m_8043_(), bLayer, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        public ShapedRecipe m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = super.m_8005_(recipeId, buffer);
            byte layer = buffer.readByte();
            return new TentLayerRecipe(recipeId, recipe.m_8043_(), layer, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        public void m_6178_(FriendlyByteBuf buffer, ShapedRecipe recipeIn) {
            super.m_6178_(buffer, recipeIn);
            TentLayerRecipe recipe = (TentLayerRecipe)recipeIn;
            buffer.writeByte((int)recipe.layer);
        }
    }
}

