/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.event;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nomadictents.NomadicTents;
import nomadictents.dimension.DynamicDimensionHelper;

public final class NTEvents {

    public static final class ForgeHandler {
        @SubscribeEvent
        public static void onPlayerWake(PlayerWakeUpEvent event) {
            if (event.getEntity().f_19853_.m_5776_()) {
                return;
            }
            ResourceKey<Level> overworldKey = NomadicTents.CONFIG.getRespawnDimension();
            ServerLevel overworld = event.getEntity().m_20194_().m_129880_(overworldKey);
            if (null == overworld) {
                NomadicTents.LOGGER.warn("Failed to load respawn dimension '" + overworldKey.m_135782_() + "'");
                return;
            }
            List<ResourceKey<Level>> tents = DynamicDimensionHelper.getTents(event.getEntity().m_20194_());
            if (event.getEntity().m_36317_() && DynamicDimensionHelper.isInsideTent(event.getEntity().f_19853_) && overworld.m_46469_().m_46207_(GameRules.f_46140_)) {
                ServerLevel tent = (ServerLevel)event.getEntity().f_19853_;
                boolean success = ForgeHandler.arePlayersSleeping(tent);
                if (((Boolean)NomadicTents.CONFIG.SLEEPING_STRICT.get()).booleanValue()) {
                    success &= ForgeHandler.arePlayersSleeping(overworld);
                    for (ResourceKey<Level> tentKey : tents) {
                        if (!success) break;
                        ServerLevel t = event.getEntity().m_20194_().m_129880_(tentKey);
                        if (t == null) continue;
                        success &= ForgeHandler.arePlayersSleeping(t);
                    }
                }
                if (success) {
                    long nextDay = overworld.m_46468_() + 24000L;
                    overworld.m_8615_(nextDay - nextDay % 24000L);
                }
            }
            for (ResourceKey<Level> tentKey : tents) {
                ServerLevel tent = event.getEntity().m_20194_().m_129880_(tentKey);
                if (null == tent) {
                    NomadicTents.LOGGER.warn("Failed to load tent dimension '" + tentKey.m_135782_() + "'");
                    continue;
                }
                tent.m_8615_(overworld.m_46468_());
                tent.m_8878_();
            }
            overworld.m_8878_();
        }

        private static boolean arePlayersSleeping(ServerLevel level) {
            if (level.m_6907_().isEmpty()) {
                return true;
            }
            for (Player player : level.m_6907_()) {
                if (player.m_5833_() || !player.m_6084_() || player.m_5803_()) continue;
                return false;
            }
            return true;
        }

        @SubscribeEvent
        public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_() && DynamicDimensionHelper.isInsideTent(event.getTo().m_135782_())) {
                ServerLevel tent = event.getEntity().m_20194_().m_129880_(event.getTo());
                if (null == tent) {
                    return;
                }
                ResourceKey<Level> overworldKey = NomadicTents.CONFIG.getRespawnDimension();
                ServerLevel overworld = event.getEntity().m_20194_().m_129880_(overworldKey);
                if (null == overworld) {
                    return;
                }
                tent.m_8615_(overworld.m_46468_());
                tent.m_8878_();
            }
        }

        @SubscribeEvent
        public static void onPlayerTeleportEnderPearl(EntityTeleportEvent.EnderPearl event) {
            if (DynamicDimensionHelper.isInsideTent(event.getPlayer().f_19853_) && ((Boolean)NomadicTents.CONFIG.RESTRICT_TELEPORT_IN_TENT.get()).booleanValue()) {
                event.setCanceled(true);
                event.getPlayer().m_5661_((Component)Component.m_237115_((String)"tent.teleport.deny"), true);
            }
        }

        @SubscribeEvent
        public static void onPlayerTeleportChorusFruit(EntityTeleportEvent.ChorusFruit event) {
            if (DynamicDimensionHelper.isInsideTent(event.getEntityLiving().f_19853_) && ((Boolean)NomadicTents.CONFIG.RESTRICT_TELEPORT_IN_TENT.get()).booleanValue()) {
                event.setCanceled(true);
                if (event.getEntityLiving() instanceof Player) {
                    ((Player)event.getEntityLiving()).m_5661_((Component)Component.m_237115_((String)"tent.teleport.deny"), true);
                }
            }
        }
    }

    public static final class ModHandler {
    }
}

