/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import nomadictents.block.TentBlock;
import nomadictents.structure.TentPlacer;
import nomadictents.tileentity.TentDoorBlockEntity;

public class ShamiyanaWallBlock
extends TentBlock {
    public static final BooleanProperty PATTERN = BooleanProperty.m_61465_((String)"pattern");
    private final DyeColor color;

    public ShamiyanaWallBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PATTERN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PATTERN});
    }

    @Override
    public BlockState getDoorAwareState(Level level, BlockState state, BlockPos pos, @Nullable BlockPos doorPos) {
        boolean pattern = (Boolean)state.m_61143_((Property)PATTERN);
        if (this.color == DyeColor.WHITE && doorPos != null) {
            TentDoorBlockEntity tentDoor;
            DyeColor tentColor;
            pattern = (pos.m_123342_() - doorPos.m_123342_()) % 3 == 0;
            BlockEntity blockEntity = level.m_7702_(doorPos);
            if (blockEntity instanceof TentDoorBlockEntity && (tentColor = (tentDoor = (TentDoorBlockEntity)blockEntity).getTent().getColor()) != null) {
                return (BlockState)TentPlacer.SHAMIYANA_WALLS.get(tentColor).get().m_49966_().m_61124_((Property)PATTERN, (Comparable)Boolean.valueOf(pattern));
            }
        }
        return (BlockState)state.m_61124_((Property)PATTERN, (Comparable)Boolean.valueOf(pattern));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        boolean pattern = context.m_43723_() != null && context.m_43723_().m_6144_();
        return (BlockState)blockState.m_61124_((Property)PATTERN, (Comparable)Boolean.valueOf(pattern));
    }

    public DyeColor getColor() {
        return this.color;
    }
}

