/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nomadictents.block.TentDoorBlock;

public class FrameBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_PROGRESS = 7;
    public static final IntegerProperty PROGRESS = IntegerProperty.m_61631_((String)"progress", (int)0, (int)7);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape AABB_PROGRESS_0 = FrameBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape AABB_PROGRESS_1 = FrameBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape AABB_PROGRESS_2 = Shapes.m_83144_();
    private static final HashMap<BlockState, VoxelShape> SHAPES = new HashMap();

    public FrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{PROGRESS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean water = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (!SHAPES.containsKey(state)) {
            int progress = (Integer)state.m_61143_((Property)PROGRESS);
            if (progress <= 1) {
                SHAPES.put(state, AABB_PROGRESS_0);
            } else if (progress <= 3) {
                SHAPES.put(state, AABB_PROGRESS_1);
            } else {
                SHAPES.put(state, AABB_PROGRESS_2);
            }
        }
        return SHAPES.get(state);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, reader, pos, context);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    @Nullable
    public static BlockPos locateDoor(Level world, BlockPos pos, Predicate<Block> tentBlockPred) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        while (pos != null && !(world.m_8055_(pos).m_60734_() instanceof TentDoorBlock)) {
            pos = FrameBlock.nextBlockOrDoor(world, checked, pos, tentBlockPred);
        }
        if (null == pos) {
            return null;
        }
        boolean lower = world.m_8055_(pos).m_61143_(TentDoorBlock.HALF) == DoubleBlockHalf.LOWER;
        return lower ? pos : pos.m_6625_(1);
    }

    public static BlockPos nextBlockOrDoor(Level worldIn, Set<BlockPos> exclude, BlockPos pos, Predicate<Block> tentBlockPred) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockState stateAt;
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (exclude.contains(checkPos) || !((stateAt = worldIn.m_8055_(checkPos)).m_60734_() instanceof FrameBlock) && !(stateAt.m_60734_() instanceof TentDoorBlock) && !tentBlockPred.test(stateAt.m_60734_())) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }
}

