/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanFeatures;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class NeapolitanBiomeModifierProvider {
    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Writable access = RegistryAccess.m_206197_();
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Registry placedFeatures = access.m_175515_(Registry.f_194567_);
        HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/strawberry_bush", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_STRAWBERRY_BUSH), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_STRAWBERRY_BUSH), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/adzuki_sprouts", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_ADZUKI_SPROUTS), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_ADZUKI_SPROUTS), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/vanilla_vine", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_VANILLA_VINE), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_VANILLA_VINE), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/mint_pond", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_MINT_POND), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.MINT_POND), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/banana_plant/common", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_COMMON_BANANA_PLANT), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_JUNGLE), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/banana_plant/uncommon", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_UNCOMMON_BANANA_PLANT), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_RARE), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/banana_plant/rare", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_RARE_BANANA_PLANT), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_VERY_RARE), GenerationStep.Decoration.VEGETAL_DECORATION));
        NeapolitanBiomeModifierProvider.addModifier(modifiers, "add_feature/banana_plant/sparse", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(NeapolitanBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, NeapolitanBiomeTags.HAS_SPARSE_BANANA_PLANT), NeapolitanBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_BEACH), GenerationStep.Decoration.VEGETAL_DECORATION));
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"neapolitan", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static HolderSet<Biome> tag(Registry<Biome> biomeRegistry, TagKey<Biome> tagKey) {
        return new HolderSet.Named(biomeRegistry, tagKey);
    }

    private static void addModifier(HashMap<ResourceLocation, BiomeModifier> modifiers, String name, BiomeModifier modifier) {
        modifiers.put(new ResourceLocation("neapolitan", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> of(Registry<PlacedFeature> placedFeatures, RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

