/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.projectile.BananaPeel;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;

public class ChimpShakeBundleGoal
extends MoveToBlockGoal {
    private final Chimpanzee chimpanzee;
    private BlockPos bundlePos = BlockPos.f_121853_;
    private int shakingTime;
    private int nextBananaTime;

    public ChimpShakeBundleGoal(Chimpanzee chimpanzeeIn, double speed, int length, int yMax) {
        super((PathfinderMob)chimpanzeeIn, speed, length, yMax);
        this.chimpanzee = chimpanzeeIn;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.chimpanzee.isDirty() || this.chimpanzee.needsSunlight()) {
            return false;
        }
        if (!this.chimpanzee.needsSnack()) {
            return false;
        }
        if (this.chimpanzee.m_6162_()) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        if (this.shakingTime > 160) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.shakingTime = 0;
        this.nextBananaTime = 30 + this.getNextBananaTime();
        this.chimpanzee.setLookingForBundle(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.chimpanzee.setDefaultAction();
        this.chimpanzee.setLookingForBundle(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        this.chimpanzee.m_21563_().m_24950_((double)this.bundlePos.m_123341_() + 0.5, (double)this.bundlePos.m_123342_() + 0.5, (double)this.bundlePos.m_123343_() + 0.5, (float)(this.chimpanzee.m_8085_() + 20), (float)this.chimpanzee.m_8132_());
        if (this.chimpanzee.m_20227_(1.0) <= (double)this.bundlePos.m_123342_() && this.bundlePos.m_203195_((Position)this.chimpanzee.m_20182_().m_82520_(0.0, (double)this.chimpanzee.m_20206_(), 0.0), 1.0)) {
            this.chimpanzee.m_20256_(this.chimpanzee.m_20184_().m_82542_(0.4, 0.0, 0.4).m_82520_(0.0, 0.1, 0.0));
            if (this.shakingTime > 30) {
                this.chimpanzee.setAction(ChimpanzeeAction.SHAKING);
                if (this.shakingTime >= this.nextBananaTime) {
                    double d0 = (double)this.bundlePos.m_123341_() + this.chimpanzee.m_217043_().m_188500_() * 0.5 + 0.25;
                    double d1 = (double)this.bundlePos.m_123343_() + this.chimpanzee.m_217043_().m_188500_() * 0.5 + 0.25;
                    if (this.chimpanzee.m_217043_().m_188503_(4) == 0) {
                        BananaPeel bananapeel = (BananaPeel)((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get()).m_20615_(this.chimpanzee.f_19853_);
                        bananapeel.m_7678_(d0, (double)this.bundlePos.m_123342_() - 0.5, d1, this.chimpanzee.m_146908_(), 0.0f);
                        bananapeel.m_20334_(this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2, -0.1, this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2);
                        this.chimpanzee.f_19853_.m_7967_((Entity)bananapeel);
                    } else {
                        ItemEntity itementity = new ItemEntity(this.chimpanzee.f_19853_, d0, (double)this.bundlePos.m_123342_() - 0.25, d1, new ItemStack((ItemLike)NeapolitanItems.BANANA_BUNCH.get()));
                        itementity.m_20334_(this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2, -0.1, this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2);
                        itementity.m_32060_();
                        this.chimpanzee.f_19853_.m_7967_((Entity)itementity);
                    }
                    this.nextBananaTime = this.shakingTime + this.getNextBananaTime();
                }
            } else {
                this.chimpanzee.setAction(ChimpanzeeAction.HANGING);
            }
            ++this.shakingTime;
        } else {
            if (this.m_25625_() && this.chimpanzee.getAction().canBeInterrupted() && this.chimpanzee.m_20096_()) {
                this.chimpanzee.m_6862_(true);
                double d0 = (double)this.f_25602_.m_123341_() + 0.5 - this.chimpanzee.m_20185_();
                double d1 = (double)this.f_25602_.m_123343_() + 0.5 - this.chimpanzee.m_20189_();
                double d2 = (double)this.bundlePos.m_123342_() - this.chimpanzee.m_20186_() + 1.0;
                double d3 = 0.8 - d2 * 0.1;
                this.chimpanzee.m_20256_(this.chimpanzee.m_20184_().m_82542_(0.5, 1.0, 0.5).m_82520_(d0 * d3, 0.3 + d2 * 0.1, d1 * d3));
            }
            this.chimpanzee.setDefaultAction();
            this.shakingTime = 0;
            this.nextBananaTime = 30 + this.getNextBananaTime();
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_60838_((BlockGetter)worldIn, pos)) {
            for (int i = 1; i < 7; ++i) {
                BlockPos blockpos = pos.m_6630_(i);
                if (i > 2 && worldIn.m_8055_(blockpos).m_60734_() == NeapolitanBlocks.BANANA_BUNDLE.get()) {
                    if (this.getBlockBeingShaken((Level)worldIn, blockpos)) {
                        return false;
                    }
                    this.bundlePos = blockpos;
                    return true;
                }
                if (!worldIn.m_8055_(blockpos).m_60838_((BlockGetter)worldIn, pos.m_6630_(i))) continue;
                return false;
            }
        }
        return false;
    }

    private int getNextBananaTime() {
        return 5 + this.chimpanzee.m_217043_().m_188503_(30);
    }

    private boolean getBlockBeingShaken(Level worldIn, BlockPos pos) {
        return !worldIn.m_6443_(Chimpanzee.class, new AABB(pos.m_7495_()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING)).isEmpty();
    }
}

