/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.neapolitan.common.block.VanillaVineTopBlock;
import com.teamabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBlockTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class VanillaVineBlock
extends Block
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)};

    public VanillaVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122411_()];
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState otherState = worldIn.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        return VanillaVineTopBlock.facingSameDirection(state, otherState) || otherState.m_204336_(NeapolitanBlockTags.VANILLA_PLANTABLE_ON);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Block block;
        if (facing == ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_() && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        VanillaVineTopBlock topVine = (VanillaVineTopBlock)((Object)NeapolitanBlocks.VANILLA_VINE.get());
        if (facing == stateIn.m_61143_((Property)FACING) && (block = facingState.m_60734_()) != this && block != topVine) {
            return (BlockState)topVine.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)stateIn.m_61143_((Property)FACING)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NeapolitanItems.VANILLA_PODS.get());
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> optional = this.nextGrowPosition(worldIn, pos, state);
        return optional.isPresent() && NetherVines.m_54963_((BlockState)worldIn.m_8055_(optional.get().m_121945_((Direction)state.m_61143_((Property)FACING))));
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        Optional<BlockPos> optional = this.nextGrowPosition((BlockGetter)worldIn, pos, state);
        if (optional.isPresent()) {
            BlockState blockstate = worldIn.m_8055_(optional.get());
            ((VanillaVineTopBlock)blockstate.m_60734_()).m_214148_(worldIn, rand, optional.get(), blockstate);
        }
    }

    private Optional<BlockPos> nextGrowPosition(BlockGetter reader, BlockPos pos, BlockState state) {
        Block block;
        BlockPos blockpos = pos;
        while ((block = reader.m_8055_(blockpos = blockpos.m_121945_((Direction)state.m_61143_((Property)FACING))).m_60734_()) == state.m_60734_()) {
        }
        return block == NeapolitanBlocks.VANILLA_VINE.get() ? Optional.of(blockpos) : Optional.empty();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        boolean flag = super.m_6864_(state, useContext);
        return (!flag || useContext.m_43722_().m_41720_() != ((Block)NeapolitanBlocks.VANILLA_VINE.get()).m_5456_()) && flag;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        VanillaVineBlock.createPoisonCloud(world, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public static void createPoisonCloud(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_150110_().f_35937_) {
            if (!player.m_21205_().m_204117_(Tags.Items.SHEARS)) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
                areaeffectcloudentity.m_19716_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19614_, 300)));
                areaeffectcloudentity.m_19712_(1.0f);
                areaeffectcloudentity.m_19732_(-0.5f);
                areaeffectcloudentity.m_19740_(10);
                areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
                areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
                world.m_7967_((Entity)areaeffectcloudentity);
            } else if (player instanceof ServerPlayer) {
                NeapolitanCriteriaTriggers.VANILLA_POISON.trigger((ServerPlayer)player);
            }
        }
    }
}

