/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.neapolitan.core.NeapolitanConfig;
import com.teamabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class StrawberryBushBlock
extends BushBlock
implements IPlantable,
BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    public static final EnumProperty<StrawberryType> TYPE = EnumProperty.m_61587_((String)"type", StrawberryType.class);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public StrawberryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(TYPE, (Comparable)((Object)StrawberryType.NONE)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean fullyGrown;
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean bl = fullyGrown = age == this.getMaxAge();
        if (!fullyGrown && player.m_21120_(hand).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (fullyGrown) {
            int strawberryCount = 1 + level.f_46441_.m_188503_(2);
            Item strawberry = state.m_61143_(TYPE) == StrawberryType.WHITE ? (Item)NeapolitanItems.WHITE_STRAWBERRIES.get() : (Item)NeapolitanItems.STRAWBERRIES.get();
            StrawberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)strawberry, strawberryCount));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1))).m_61124_(TYPE, (Comparable)((Object)StrawberryType.NONE)), 2);
            if (player instanceof ServerPlayer) {
                NeapolitanCriteriaTriggers.HARVEST_STRAWBERRIES.trigger((ServerPlayer)player, state);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_216271_((RandomSource)worldIn.f_46441_, (int)2, (int)5);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 13) {
            int growthChance;
            int age = this.getAge(state);
            int maxAgeForPos = worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50546_) ? 2 : this.getMaxAge();
            int n = growthChance = !worldIn.m_46471_() ? 7 : 5;
            if (age < maxAgeForPos && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_(growthChance) == 0 ? 1 : 0) != 0)) {
                if (age != 5) {
                    worldIn.m_7731_(pos, this.withAge(age + 1), 2);
                } else {
                    worldIn.m_7731_(pos, (BlockState)this.withAge(age + 1).m_61124_(TYPE, (Comparable)((Object)(this.isWhite(worldIn, pos) ? StrawberryType.WHITE : StrawberryType.RED))), 2);
                }
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity entity;
        if (worldIn.f_46441_.m_188503_(15) == 0 && (entityIn.f_19790_ != entityIn.m_20185_() || entityIn.f_19792_ != entityIn.m_20189_())) {
            double d0 = Math.abs(entityIn.m_20185_() - entityIn.f_19790_);
            double d1 = Math.abs(entityIn.m_20189_() - entityIn.f_19792_);
            if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                worldIn.m_5594_(null, pos, SoundEvents.f_11992_, SoundSource.BLOCKS, 1.5f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            }
        }
        if (entityIn instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entityIn)) {
            worldIn.m_46953_(pos, true, entityIn);
        }
        if (entityIn instanceof LivingEntity && (entity = (LivingEntity)entityIn).m_6336_() == MobType.f_21642_ && (Integer)state.m_61143_((Property)AGE) > 0 && ((Boolean)NeapolitanConfig.COMMON.strawberryBushArthropodInvisibility.get()).booleanValue()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 3, 0, false, false, false));
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (entity instanceof Creeper) {
            return BlockPathTypes.DANGER_OTHER;
        }
        return super.getBlockPathType(state, world, pos, entity);
    }

    protected ItemLike getSeedsItem() {
        return (ItemLike)NeapolitanItems.STRAWBERRY_PIPS.get();
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, TYPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    private boolean isWhite(ServerLevel worldIn, BlockPos pos) {
        return pos.m_123342_() >= (Integer)NeapolitanConfig.COMMON.whiteStrawberryMinHeight.get() && worldIn.m_46472_() == Level.f_46428_ || worldIn.m_46472_() == Level.f_46430_;
    }

    public boolean m_7370_(BlockGetter block, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int age = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((Level)worldIn), this.getMaxAge());
        if (age != 6) {
            worldIn.m_7731_(pos, this.withAge(age), 2);
        } else {
            worldIn.m_7731_(pos, (BlockState)this.withAge(age).m_61124_(TYPE, (Comparable)((Object)(this.isWhite(worldIn, pos) ? StrawberryType.WHITE : StrawberryType.RED))), 2);
        }
    }

    public static enum StrawberryType implements StringRepresentable
    {
        NONE("none"),
        RED("red"),
        WHITE("white");

        private final String name;

        private StrawberryType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

