/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBlockTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class MintBlock
extends BushBlock
implements IPlantable,
BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    public static final IntegerProperty SPROUTS = IntegerProperty.m_61631_((String)"sprouts", (int)1, (int)4);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};

    public MintBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SPROUTS, (Comparable)Integer.valueOf(1)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!this.isMaxAge(state) && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (this.isMaxAge(state)) {
            MintBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)NeapolitanItems.MINT_LEAVES.get(), ((Integer)state.m_61143_((Property)SPROUTS)).intValue()));
            worldIn.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)SPROUTS) < 4 || super.m_6864_(state, useContext);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NeapolitanItems.MINT_SPROUT.get());
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = (Integer)state.m_61143_((Property)AGE);
        if (worldIn.m_45524_(pos, 0) >= 9 && !this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(9) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        } else if (this.isMaxAge(state) && random.m_188503_(3) != 0) {
            MintBlock.spawnGrowthParticles(worldIn, pos, random);
            Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
                BlockPos offsetPos = pos.m_121945_(direction);
                BlockState offsetState = worldIn.m_8055_(offsetPos);
                if (!offsetState.m_204336_(NeapolitanBlockTags.UNAFFECTED_BY_MINT)) {
                    offsetState.m_222972_(worldIn, offsetPos, random);
                }
            });
        }
    }

    private static void spawnGrowthParticles(ServerLevel worldIn, BlockPos posIn, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(posIn);
        if (!blockstate.m_60795_()) {
            double d1 = blockstate.m_60808_((BlockGetter)worldIn, posIn).m_83297_(Direction.Axis.Y);
            for (int i = 0; i < 8; ++i) {
                double d8;
                double d7;
                double d2 = random.m_188583_() * 0.02;
                double d3 = random.m_188583_() * 0.02;
                double d4 = random.m_188583_() * 0.02;
                double d6 = (double)posIn.m_123341_() + random.m_188500_();
                if (worldIn.m_8055_(new BlockPos(d6, d7 = (double)posIn.m_123342_() + random.m_188500_() * d1, d8 = (double)posIn.m_123343_() + random.m_188500_()).m_7495_()).m_60795_()) continue;
                NetworkUtil.spawnParticle((String)"neapolitan:mint_boost", (double)d6, (double)d7, (double)d8, (double)d2, (double)d3, (double)d4);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)SPROUTS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)SPROUTS) + 1)));
        }
        return super.m_5573_(context);
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 4;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, SPROUTS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public boolean m_7370_(BlockGetter block, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

