/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class BananaFrondBlock
extends BushBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public BananaFrondBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(facing.m_122424_());
        BlockState blockState = worldIn.m_8055_(blockpos);
        return BananaFrondBlock.m_49863_((LevelReader)worldIn, (BlockPos)blockpos, (Direction)facing) || this.m_6266_(blockState, (BlockGetter)worldIn, blockpos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_204336_(BlockTags.f_13035_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return state.m_61143_((Property)FACING) == Direction.UP && worldIn instanceof Level && ((Level)worldIn).m_46758_(pos);
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        if (rand.m_188503_(6) == 0) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (Level)world, rand, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (this.m_7370_((BlockGetter)worldIn, pos, state, worldIn.m_5776_()) && BananaFrondBlock.canGrowOn(worldIn.m_8055_(pos.m_7495_())) && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_(2) == 0 ? 1 : 0) != 0)) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (Level)worldIn, rand, pos);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public static boolean attemptGrowBanana(int size, Level world, RandomSource rand, BlockPos pos) {
        int i;
        BlockPos blockPos = pos;
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        BlockPos upFrond = null;
        BlockPos bundle = null;
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.m_7494_();
        }
        upFrond = blockPos;
        i = 0;
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.m_122434_().m_122479_()) continue;
                    if (i == size - 1) {
                        if (rand.m_188503_(4) != 0) {
                            largeFronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (rand.m_188499_()) {
                            fronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        if (rand.m_188499_() && bundle == null) {
                            bundle = stalk.m_121945_(direction);
                            continue;
                        }
                        smallFronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || rand.m_188503_(3) == 0) continue;
                    smallFronds.put(stalk.m_121945_(direction), direction);
                }
            }
            ++i;
        }
        if (BananaFrondBlock.isAirAt(world, pos, size) && pos.m_123342_() < world.m_151558_() - size) {
            for (BlockPos blockPos2 : stalks) {
                world.m_7731_(blockPos2, ((Block)NeapolitanBlocks.BANANA_STALK.get()).m_49966_(), 2);
            }
            world.m_7731_(upFrond, ((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_(), 2);
            if (bundle != null) {
                world.m_7731_(bundle, ((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).m_49966_(), 2);
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                world.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)smallFronds.get(blockPos2))), 2);
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                world.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)fronds.get(blockPos2))), 2);
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                world.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)largeFronds.get(blockPos2))), 2);
            }
            return true;
        }
        return false;
    }

    public static boolean canGrowOn(BlockState state) {
        return state.m_204336_(Tags.Blocks.GRAVEL) || state.m_204336_(Tags.Blocks.SAND);
    }

    private static boolean isAirAt(Level world, BlockPos pos, int size) {
        for (int i = 0; i < size + 1; ++i) {
            if (i != 0 && !world.m_46859_(pos) && !world.m_8055_(pos).m_60767_().m_76336_()) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.m_122434_().m_122479_() || world.m_46859_(pos.m_121945_(direction)) || world.m_8055_(pos.m_121945_(direction)).m_60767_().m_76336_()) continue;
                return false;
            }
            pos = pos.m_7494_();
        }
        return true;
    }

    private static int getSizeForFrond(RandomSource rand, Block frond) {
        int extra = 0;
        if (frond == NeapolitanBlocks.SMALL_BANANA_FROND.get()) {
            extra = rand.m_188503_(2);
        }
        if (frond == NeapolitanBlocks.BANANA_FROND.get()) {
            extra = 1 + rand.m_188503_(2);
        }
        if (frond == NeapolitanBlocks.LARGE_BANANA_FROND.get()) {
            extra = 1 + rand.m_188503_(3);
        }
        return 3 + extra;
    }
}

