/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.neapolitan.client.model.ChimpanzeeModel;
import com.teamabnormals.neapolitan.client.renderer.entity.layers.ChimpanzeeDirtLayer;
import com.teamabnormals.neapolitan.client.renderer.entity.layers.ChimpanzeeDyeLayer;
import com.teamabnormals.neapolitan.client.renderer.entity.layers.ChimpanzeeItemLayer;
import com.teamabnormals.neapolitan.client.renderer.entity.layers.ChimpanzeePaleSkinLayer;
import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeType;
import com.teamabnormals.neapolitan.core.other.NeapolitanModelLayers;
import java.util.Locale;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChimpanzeeRenderer
extends MobRenderer<Chimpanzee, ChimpanzeeModel<Chimpanzee>> {
    public ChimpanzeeRenderer(EntityRendererProvider.Context context) {
        super(context, new ChimpanzeeModel(context.m_174023_(NeapolitanModelLayers.CHIMPANZEE)), 0.4f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new ChimpanzeeModel(context.m_174023_(NeapolitanModelLayers.CHIMPANZEE_INNER_ARMOR)), new ChimpanzeeModel(context.m_174023_(NeapolitanModelLayers.CHIMPANZEE_OUTER_ARMOR))));
        this.m_115326_(new ChimpanzeePaleSkinLayer(this));
        this.m_115326_(new ChimpanzeeDirtLayer(this));
        this.m_115326_(new ChimpanzeeDyeLayer(this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_(new ChimpanzeeItemLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Chimpanzee chimpanzee) {
        ChimpanzeeType type = ChimpanzeeType.byId(chimpanzee.getChimpanzeeType());
        String textureend = chimpanzee.isMouthOpen() ? "_chimpanzee_mouth_open.png" : "_chimpanzee.png";
        return new ResourceLocation("neapolitan", "textures/entity/chimpanzee/" + type.name().toLowerCase(Locale.ROOT) + textureend);
    }

    protected void setupRotations(Chimpanzee chimpanzee, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)chimpanzee, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        float f = chimpanzee.getFlipAnim(partialTicks);
        if (f > 0.0f) {
            float f1 = (float)Math.PI * f / 10.0f;
            matrixStackIn.m_85837_(0.0, (double)(-Mth.m_14089_((float)f1)) * 0.8 + 0.8, (double)Mth.m_14031_((float)f1) * 0.8);
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-f * 18.0f));
        }
    }

    protected boolean isShaking(Chimpanzee entityIn) {
        return entityIn.getApeModeTime() > 0;
    }
}

