/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import se.mickelus.mutil.gui.GuiElement;

public class GuiTexture
extends GuiElement {
    protected ResourceLocation textureLocation;
    protected int textureX;
    protected int textureY;
    protected int color = 0xFFFFFF;
    protected Supplier<ShaderInstance> shader = GameRenderer::m_172817_;
    private boolean useDefaultBlending = true;

    public GuiTexture(int x, int y, int width, int height, ResourceLocation textureLocation) {
        this(x, y, width, height, 0, 0, textureLocation);
    }

    public GuiTexture(int x, int y, int width, int height, int textureX, int textureY, ResourceLocation textureLocation) {
        super(x, y, width, height);
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureLocation = textureLocation;
    }

    public GuiTexture setTextureCoordinates(int x, int y) {
        this.textureX = x;
        this.textureY = y;
        return this;
    }

    public GuiTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public GuiTexture setShader(Supplier<ShaderInstance> shader) {
        this.shader = shader;
        return this;
    }

    public void setUseDefaultBlending(boolean useDefault) {
        this.useDefaultBlending = useDefault;
    }

    @Override
    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        this.drawTexture(matrixStack, this.textureLocation, refX + this.x, refY + this.y, this.width, this.height, this.textureX, this.textureY, this.color, this.getOpacity() * opacity);
    }

    protected void drawTexture(PoseStack matrixStack, ResourceLocation textureLocation, int x, int y, int width, int height, int u, int v, int color, float opacity) {
        RenderSystem.m_157427_(this.shader);
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)opacity);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
        RenderSystem.m_69478_();
        if (this.useDefaultBlending) {
            RenderSystem.m_69453_();
        }
        this.m_93228_(matrixStack, x, y, u, v, width, height);
    }
}

