/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.forge.MapDecorationRegistryImpl;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.SimpleDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationRegistry {
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC = Codec.either(CustomDecorationType.CODEC, SimpleDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((SimpleDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC_BUGGY_2 = MapDecorationType.GENERIC_CODEC;
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC_2 = new Codec<MapDecorationType<?, ?>>(){

        public <T> DataResult<T> encode(MapDecorationType<?, ?> input, DynamicOps<T> ops, T prefix) {
            if (input instanceof CustomDecorationType) {
                CustomDecorationType type = (CustomDecorationType)input;
                return CustomDecorationType.CODEC.encode((Object)type, ops, prefix);
            }
            return SimpleDecorationType.CODEC.encode((Object)((SimpleDecorationType)input), ops, prefix);
        }

        public <T> DataResult<Pair<MapDecorationType<?, ?>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult first = CustomDecorationType.CODEC.decode(ops, input);
            if (first.result().isPresent()) {
                return first.map(v -> v.mapFirst(a -> a));
            }
            return SimpleDecorationType.CODEC.decode(ops, input).map(v -> v.mapFirst(a -> a));
        }
    };
    public static final Map<ResourceLocation, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    public static final ResourceLocation GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    public static final Map<ResourceLocation, Supplier<CustomDecorationType<?, ?>>> CODE_TYPES_FACTORIES = new HashMap();

    public static <T> void registerCustomMapSavedData(ResourceLocation name, Class<T> type, Function<CompoundTag, T> load, BiConsumer<CompoundTag, T> save, PropertyDispatch.TriFunction<MapItemSavedData, Entity, T, Boolean> onItemUpdate, PropertyDispatch.TriFunction<MapItemSavedData, ItemStack, T, Component> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDecorationRegistry.get(GENERIC_STRUCTURE_ID);
    }

    public static void register(ResourceLocation id, Supplier<CustomDecorationType<?, ?>> markerType) {
        CODE_TYPES_FACTORIES.put(id, markerType);
        MapDecorationRegistry.registerInternal(id, markerType::get);
    }

    public static void registerSimple(String modId, String name) {
        ResourceLocation id = new ResourceLocation(modId, name);
        MapDecorationRegistry.register(id, () -> new CustomDecorationType(id, CustomMapDecoration::new));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerInternal(ResourceLocation id, Supplier<MapDecorationType<?, ?>> markerType) {
        void var1_1;
        MapDecorationRegistryImpl.registerInternal(id, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDecorationRegistryImpl.init();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceKey<Registry<MapDecorationType<?, ?>>> getRegistryKey() {
        return MapDecorationRegistryImpl.getRegistryKey();
    }

    public static Registry<MapDecorationType<?, ?>> getDataPackRegistry() {
        return Utils.hackyGetRegistryAccess().m_175515_(MapDecorationRegistry.getRegistryKey());
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDecorationRegistry.getDataPackRegistry().m_123024_().toList();
    }

    public static Set<Map.Entry<ResourceKey<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDecorationRegistry.getDataPackRegistry().m_6579_();
    }

    @Nullable
    public static ResourceLocation getID(MapDecorationType<?, ?> s) {
        return MapDecorationRegistry.getDataPackRegistry().m_7981_(s);
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDecorationRegistry.get(new ResourceLocation(id));
    }

    public static MapDecorationType<?, ?> get(ResourceLocation id) {
        return (MapDecorationType)MapDecorationRegistry.getDataPackRegistry().m_7745_(id);
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(ResourceLocation id) {
        return MapDecorationRegistry.getDataPackRegistry().m_6612_(id);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapBlockMarker<?> readWorldMarker(CompoundTag compound) {
        for (Map.Entry<ResourceKey<MapDecorationType<?, ?>>, MapDecorationType<?, ?>> e : MapDecorationRegistry.getEntries()) {
            String id = e.getKey().m_135782_().toString();
            if (!compound.m_128441_(id)) continue;
            return e.getValue().loadMarkerFromNBT(compound.m_128469_(id));
        }
        return null;
    }

    @ApiStatus.Internal
    public static List<MapBlockMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDecorationRegistry.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }
}

