/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.event.QuestObjectiveEventHandler;
import com.minecolonies.coremod.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.coremod.quests.objectives.IPlaceBlockObjectiveTemplate;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceBlockObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IPlaceBlockObjectiveTemplate {
    private final int qty;
    private final Block blockToPlace;
    private final int nextObjective;

    public PlaceBlockObjectiveTemplate(int target, int qty, Block blockToPlace, int nextObjective, List<Integer> rewards) {
        super(target, PlaceBlockObjectiveTemplate.buildDialogueTree(blockToPlace), rewards);
        this.qty = qty;
        this.nextObjective = nextObjective;
        this.blockToPlace = blockToPlace;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(Block blockToMine) {
        MutableComponent text = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.placeblock", (Object[])new Object[]{blockToMine.m_49954_()});
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int quantity = details.get("qty").getAsInt();
        Block block = (Block)((Holder)ForgeRegistries.BLOCKS.getHolder(new ResourceLocation(details.get("block").getAsString())).get()).get();
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new PlaceBlockObjectiveTemplate(target, quantity, block, nextObj, PlaceBlockObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestPlaceObjectiveListener(this.blockToPlace, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
        return new BlockPlacementProgressInstance();
    }

    @Override
    @Nullable
    public IObjectiveInstance createObjectiveInstance() {
        return new BlockPlacementProgressInstance();
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.removeQuestPlaceBlockObjectiveListener(this.blockToPlace, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    @Override
    public void onBlockPlace(IObjectiveInstance blockPlacementProgressData, IQuestInstance colonyQuest, Player player) {
        if (blockPlacementProgressData.isFulfilled()) {
            return;
        }
        ++((BlockPlacementProgressInstance)blockPlacementProgressData).currentProgress;
        if (blockPlacementProgressData.isFulfilled()) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(player, this.nextObjective);
        }
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addQuestPlaceObjectiveListener(this.blockToPlace, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    public class BlockPlacementProgressInstance
    implements IObjectiveInstance {
        private int currentProgress = 0;

        @Override
        public boolean isFulfilled() {
            return this.currentProgress >= PlaceBlockObjectiveTemplate.this.qty;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("quantity", this.currentProgress);
            return compoundTag;
        }

        @Override
        public int getMissingQuantity() {
            return PlaceBlockObjectiveTemplate.this.qty > this.currentProgress ? PlaceBlockObjectiveTemplate.this.qty - this.currentProgress : 0;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentProgress = nbt.m_128451_("quantity");
        }
    }
}

