/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers.main;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.OpenPlantationFieldBuildWindowMessage;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlantationFieldPlacementHandler
implements ISurvivalBlueprintHandler {
    public static final String ID = "minecolonies:plantation_field";

    public String getId() {
        return ID;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.blueprint.placement");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel level, Player player, BlockPos pos, PlacementSettings placementSettings) {
        BlockState blockState = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        if (!blockState.m_60713_(ModBlocks.blockPlantationField)) {
            return false;
        }
        IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)level, pos);
        if (colonyView == null) {
            return false;
        }
        if (!colonyView.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            return false;
        }
        return colonyView.isCoordInColony((Level)level, pos);
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level level, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        Network.getNetwork().sendToPlayer(new OpenPlantationFieldBuildWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
    }
}

