/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateRequestStateMessage
extends AbstractColonyServerMessage {
    private IToken<?> token;
    private ItemStack itemStack = ItemStackUtils.EMPTY;
    private RequestState state;

    public UpdateRequestStateMessage() {
    }

    public UpdateRequestStateMessage(IColony colony, IToken<?> requestId, RequestState state, ItemStack itemStack) {
        super(colony);
        this.token = requestId;
        this.state = state;
        this.itemStack = itemStack;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(buf.m_130260_());
        this.state = RequestState.values()[buf.readInt()];
        if (this.state == RequestState.OVERRULED) {
            this.itemStack = buf.m_130267_();
        }
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130079_(StandardFactoryController.getInstance().serialize(this.token));
        buf.writeInt(this.state.ordinal());
        if (this.state == RequestState.OVERRULED) {
            buf.m_130055_(this.itemStack);
        }
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (this.state == RequestState.OVERRULED) {
            colony.getRequestManager().overruleRequest(this.token, this.itemStack);
            return;
        }
        colony.getRequestManager().updateRequestState(this.token, this.state);
    }
}

