/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.fields.registry.FieldDataManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewFieldsUpdateMessage
implements IMessage {
    private int colonyId;
    private ResourceKey<Level> dimension;
    private Map<IField, IField> fields;

    public ColonyViewFieldsUpdateMessage() {
    }

    public ColonyViewFieldsUpdateMessage(@NotNull IColony colony, @NotNull Set<IField> fields) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.fields = new HashMap<IField, IField>();
        fields.forEach(field -> this.fields.put((IField)field, (IField)field));
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeInt(this.fields.size());
        for (IField field : this.fields.keySet()) {
            FriendlyByteBuf fieldBuffer = FieldDataManager.fieldToBuffer(field);
            buf.writeInt(fieldBuffer.readableBytes());
            buf.writeBytes((ByteBuf)fieldBuffer);
        }
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.fields = new HashMap<IField, IField>();
        int fieldCount = buf.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            int readableBytes = buf.readInt();
            FriendlyByteBuf fieldData = new FriendlyByteBuf(Unpooled.buffer((int)readableBytes));
            buf.readBytes((ByteBuf)fieldData, readableBytes);
            IField parsedField = FieldDataManager.bufferToField(fieldData);
            this.fields.put(parsedField, parsedField);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView view = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (view != null) {
            HashSet<IField> updatedFields = new HashSet<IField>();
            view.getFields(field -> true).forEach(existingField -> {
                if (this.fields.containsKey(existingField)) {
                    FriendlyByteBuf copyBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    this.fields.get(existingField).serialize(copyBuffer);
                    existingField.deserialize(copyBuffer);
                    updatedFields.add((IField)existingField);
                }
            });
            updatedFields.addAll(this.fields.keySet());
            view.handleColonyFieldViewUpdateMessage(updatedFields);
        } else {
            Log.getLogger().error("Colony view does not exist for ID #{}", (Object)this.colonyId);
        }
    }
}

