/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewCitizenViewMessage
implements IMessage {
    private int colonyId;
    private int citizenId;
    private FriendlyByteBuf citizenBuffer;
    private ResourceKey<Level> dimension;

    public ColonyViewCitizenViewMessage() {
    }

    public ColonyViewCitizenViewMessage(@NotNull Colony colony, @NotNull ICitizenData citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = new FriendlyByteBuf(Unpooled.buffer());
        this.dimension = citizen.getColony().getDimension();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.citizenBuffer = new FriendlyByteBuf(buf.retain());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.citizenBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBytes((ByteBuf)this.citizenBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyViewCitizensMessage(this.colonyId, this.citizenId, this.citizenBuffer, this.dimension);
        this.citizenBuffer.release();
    }
}

