/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.datagenerators.sounds.SoundsJson;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DefaultSoundProvider
implements DataProvider {
    private final DataGenerator generator;
    private final ExistingFileHelper fileHelper;
    private JsonObject sounds;

    public DefaultSoundProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.fileHelper = existingFileHelper;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.sounds = new JsonObject();
        File soundFolder = this.generator.m_123916_().getParent().getParent().getParent().resolve("main").resolve("resources").resolve("assets").resolve("minecolonies").resolve("sounds").resolve("mob").resolve("citizen").toFile();
        ArrayList<ResourceLocation> mainTypes = new ArrayList<ResourceLocation>(ModJobs.getJobs());
        mainTypes.remove(ModJobs.placeHolder.getId());
        mainTypes.add(new ResourceLocation("minecolonies", "unemployed"));
        mainTypes.add(new ResourceLocation("minecolonies", "visitor"));
        if (soundFolder.isDirectory()) {
            File[] list;
            for (File file : list = soundFolder.listFiles()) {
                String name = file.getName();
                if (!file.isDirectory()) continue;
                ArrayList<CallSite> soundList = new ArrayList<CallSite>();
                File[] subList = file.listFiles();
                for (File soundFile : subList) {
                    String soundName = soundFile.getName();
                    soundList.add((CallSite)((Object)("minecolonies:mob/citizen/" + name + "/" + soundName.replace(".ogg", ""))));
                }
                for (ResourceLocation job : mainTypes) {
                    for (EventType event : EventType.values()) {
                        this.sounds.add("citizen." + job.m_135815_() + "." + name + "." + event.getId(), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), soundList));
                    }
                }
            }
        }
        ArrayList<String> childSounds = new ArrayList<String>();
        childSounds.add("minecolonies:mob/citizen/child/laugh1");
        childSounds.add("minecolonies:mob/citizen/child/laugh2");
        for (EventType eventType : EventType.values()) {
            this.sounds.add("mob.child.male." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), childSounds));
            this.sounds.add("mob.child.female." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), childSounds));
        }
        for (RaiderType raiderType : RaiderType.values()) {
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".death", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/death")));
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".say", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/say")));
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".hurt", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/hurt1", (Object)"minecolonies:mob/barbarian/hurt2", (Object)"minecolonies:mob/barbarian/hurt3", (Object)"minecolonies:mob/barbarian/hurt4")));
        }
        this.sounds.add("mob.citizen.snore", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/citizen/snore")));
        JsonObject jsonObject = this.getDefaultProperties();
        jsonObject.addProperty("attenuation_distance", (Number)23);
        jsonObject.addProperty("stream", Boolean.valueOf(true));
        jsonObject.addProperty("comment", "Credits to Darren Curtis - Fireside Tales");
        this.sounds.add("tile.tavern.tavern_theme", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)jsonObject, (List)ImmutableList.of((Object)"minecolonies:tile/tavern/tavern_theme")));
        this.sounds.add("mob.mercenary.attack", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/attack/attack1", (Object)"minecolonies:mob/mercenary/attack/attack2", (Object)"minecolonies:mob/mercenary/attack/attack3", (Object)"minecolonies:mob/mercenary/attack/attack4")));
        this.sounds.add("mob.mercenary.celebrate", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/celebrate/celebrate1")));
        this.sounds.add("mob.mercenary.die", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/die/death1", (Object)"minecolonies:mob/mercenary/die/death2")));
        this.sounds.add("mob.mercenary.hurt", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/hurt/hurt1", (Object)"minecolonies:mob/mercenary/hurt/hurt2", (Object)"minecolonies:mob/mercenary/hurt/hurt3")));
        this.sounds.add("mob.mercenary.say", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/say/say1", (Object)"minecolonies:mob/mercenary/say/say2", (Object)"minecolonies:mob/mercenary/say/say3")));
        this.sounds.add("mob.mercenary.step", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/mercenary/step/step1", (Object)"minecolonies:mob/mercenary/step/step2", (Object)"minecolonies:mob/mercenary/step/step3", (Object)"minecolonies:mob/mercenary/step/step4")));
        this.sounds.add("tile.sawmill.saw", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:tile/sawmill/saw")));
        this.add("record", false, "raid.raid_alert", "raid.raid_alert_early", "raid.raid_won", "raid.raid_won_early");
        this.add("music", true, "raid.desert.desert_raid", "raid.desert.desert_raid_warning", "raid.desert.desert_raid_victory", "raid.amazon.amazon_raid");
        Path savePath = this.generator.m_123916_().resolve("assets/minecolonies/").resolve("sounds.json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)this.sounds, (Path)savePath);
    }

    @NotNull
    public String m_6055_() {
        return "Default Sound Json Provider";
    }

    private JsonObject getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("stream", Boolean.valueOf(false));
        return properties;
    }

    private void add(String category, boolean stream, String ... ids) {
        for (String id : ids) {
            JsonObject obj = new JsonObject();
            obj.addProperty("stream", Boolean.valueOf(stream));
            this.sounds.add(id, (JsonElement)SoundsJson.createSoundJson((String)category, (JsonObject)obj, (List)ImmutableList.of((Object)("minecolonies:" + id.replace(".", "/")))));
        }
    }
}

