/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.coremod.quests.objectives.IBreakBlockObjectiveTemplate;
import com.minecolonies.coremod.quests.objectives.IKillEntityObjectiveTemplate;
import com.minecolonies.coremod.quests.objectives.IPlaceBlockObjectiveTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class QuestObjectiveEventHandler {
    private static final Map<Block, Map<UUID, IQuestInstance>> breakBlockObjectives = new HashMap<Block, Map<UUID, IQuestInstance>>();
    private static final Map<EntityType<?>, Map<UUID, IQuestInstance>> entityKillObjectives = new HashMap();
    private static final Map<Block, Map<UUID, IQuestInstance>> placeBlockObjectives = new HashMap<Block, Map<UUID, IQuestInstance>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.m_5776_()) {
            return;
        }
        Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
        if (breakBlockObjectives.containsKey(block) && breakBlockObjectives.get(block).containsKey(event.getPlayer().m_20148_())) {
            IQuestInstance colonyQuest = breakBlockObjectives.get(block).get(event.getPlayer().m_20148_());
            IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getIndex());
            if (objective instanceof IBreakBlockObjectiveTemplate) {
                ((IBreakBlockObjectiveTemplate)((Object)objective)).onBlockBreak(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, event.getPlayer());
            } else {
                breakBlockObjectives.get(block).remove(event.getPlayer().m_20148_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof Player && entityKillObjectives.containsKey(event.getEntity().m_6095_()) && entityKillObjectives.get(event.getEntity().m_6095_()).containsKey(event.getSource().m_7639_().m_20148_())) {
            IQuestInstance colonyQuest = entityKillObjectives.get(event.getEntity().m_6095_()).get(event.getSource().m_7639_().m_20148_());
            IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getIndex());
            if (objective instanceof IKillEntityObjectiveTemplate) {
                ((IKillEntityObjectiveTemplate)((Object)objective)).onEntityKill(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, (Player)event.getSource().m_7639_());
            } else {
                entityKillObjectives.get(event.getEntity().m_6095_()).remove(event.getEntity().m_20148_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.m_5776_() || !(event.getEntity() instanceof Player)) {
            return;
        }
        Block block = event.getPlacedBlock().m_60734_();
        if (placeBlockObjectives.containsKey(block) && placeBlockObjectives.get(block).containsKey(event.getEntity().m_20148_())) {
            IQuestInstance colonyQuest = placeBlockObjectives.get(block).get(event.getEntity().m_20148_());
            IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getIndex());
            if (objective instanceof IPlaceBlockObjectiveTemplate) {
                ((IPlaceBlockObjectiveTemplate)((Object)objective)).onBlockPlace(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, (Player)event.getEntity());
            } else {
                placeBlockObjectives.get(block).remove(event.getEntity().m_20148_());
            }
        }
    }

    public static void addQuestMineObjectiveListener(Block blockToMine, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = breakBlockObjectives.getOrDefault(blockToMine, new HashMap());
        currentMap.put(assignedPlayer, colonyQuest);
        breakBlockObjectives.put(blockToMine, currentMap);
    }

    public static void removeQuestMineObjectiveListener(Block blockToMine, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((Map)breakBlockObjectives.getOrDefault(blockToMine, new HashMap())).remove(assignedPlayer);
    }

    public static void addQuestPlaceObjectiveListener(Block blockToPlace, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = placeBlockObjectives.getOrDefault(blockToPlace, new HashMap());
        currentMap.put(assignedPlayer, colonyQuest);
        placeBlockObjectives.put(blockToPlace, currentMap);
    }

    public static void removeQuestPlaceBlockObjectiveListener(Block blockToPlace, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((Map)placeBlockObjectives.getOrDefault(blockToPlace, new HashMap())).remove(assignedPlayer);
    }

    public static void addKillQuestObjectiveListener(EntityType<?> entityToKill, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = entityKillObjectives.getOrDefault(entityToKill, new HashMap());
        currentMap.put(assignedPlayer, colonyQuest);
        entityKillObjectives.put(entityToKill, currentMap);
    }

    public static void removeKillQuestObjectiveListener(EntityType<?> entityToKill, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((Map)entityKillObjectives.getOrDefault(entityToKill, new HashMap())).remove(assignedPlayer);
    }
}

