/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.amazonevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.amazons.EntityAmazonChief;
import com.minecolonies.coremod.entity.mobs.amazons.EntityAmazonSpearman;
import com.minecolonies.coremod.entity.mobs.amazons.EntityArcherAmazon;
import com.minecolonies.coremod.network.messages.client.PlayAudioMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class AmazonRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation AMAZON_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "amazon_raid");
    private int musicCooldown = 0;

    public AmazonRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return AMAZON_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.m_6084_()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityAmazonChief && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityArcherAmazon && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityAmazonSpearman && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.m_20148_());
            return;
        }
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.m_7006_(true);
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.raid.amazon.name");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (--this.musicCooldown <= 0) {
            PlayAudioMessage.sendToAll(this.getColony(), true, true, new PlayAudioMessage(RaidSounds.AMAZON_RAID));
            this.musicCooldown = 20;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityAmazonChief) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherAmazon) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityAmazonSpearman) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static AmazonRaidEvent loadFromNBT(IColony colony, CompoundTag compound) {
        AmazonRaidEvent event = new AmazonRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.AMAZONSPEARMAN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.AMAZON;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.AMAZONCHIEF;
    }
}

