/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemDecorator;

public class ClipBoardDecorator
implements IItemDecorator {
    private static IColonyView colonyView;
    private static boolean render;
    private long lastChange;

    public boolean render(Font font, ItemStack stack, int xOffset, int yOffset, float blitOffset) {
        CompoundTag compoundTag;
        long gametime = Minecraft.m_91087_().f_91073_.m_46467_();
        if (this.lastChange != gametime && gametime % 40L == 0L) {
            this.lastChange = gametime;
            boolean bl = render = !render;
        }
        if (render && (compoundTag = stack.m_41783_()) != null) {
            int colonyId = compoundTag.m_128451_("colony");
            colonyView = IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
            if (colonyView != null) {
                HashSet asyncRequest = new HashSet();
                for (ICitizenDataView view : colonyView.getCitizens().values()) {
                    if (view.getJobView() == null) continue;
                    asyncRequest.addAll(view.getJobView().getAsyncRequests());
                }
                IRequestManager requestManager = colonyView.getRequestManager();
                if (requestManager != null) {
                    IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
                    IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
                    HashSet requestTokens = new HashSet();
                    requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
                    requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
                    int count = 0;
                    for (IToken iToken : requestTokens) {
                        if (asyncRequest.contains(iToken)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        PoseStack ps = new PoseStack();
                        ps.m_85836_();
                        ps.m_85837_(0.0, 0.0, 500.0);
                        GuiComponent.m_93215_((PoseStack)ps, (Font)font, (Component)Component.m_237113_((String)("" + count)), (int)(xOffset + 15), (int)(yOffset - 2), (int)-47872);
                        ps.m_85849_();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static {
        render = false;
    }
}

