/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.GraveyardManagementModuleView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GraveyardManagementWindow
extends AbstractModuleWindow {
    private static final String HUT_GRAVEYARD_RESOURCE_SUFFIX = ":gui/layouthuts/layoutgraveyard.xml";
    private static final String LIST_GRAVES = "graves";
    private static final String LIST_CITIZEN = "citizen";
    private static final String TAG_NAME = "name";
    private static final String TAG_CITIZEN_NAME = "citizenName";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private final ClientLevel world;
    private final GraveyardManagementModuleView moduleView;

    public GraveyardManagementWindow(IBuildingView building, GraveyardManagementModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutgraveyard.xml");
        this.world = Minecraft.m_91087_().f_91073_;
        this.moduleView = moduleView;
    }

    public void onOpened() {
        super.onOpened();
        ScrollingList graveList = (ScrollingList)this.findPaneOfTypeByID(LIST_GRAVES, ScrollingList.class);
        graveList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return GraveyardManagementWindow.this.moduleView.getGraves().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos grave = GraveyardManagementWindow.this.moduleView.getGraves().get(index);
                @NotNull String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(grave, GraveyardManagementWindow.this.buildingView.getPosition())));
                Component direction = BlockPosUtil.calcDirection(GraveyardManagementWindow.this.buildingView.getPosition(), grave);
                BlockEntity entity = GraveyardManagementWindow.this.world.m_7702_(grave);
                if (entity instanceof TileEntityGrave) {
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_NAME, Text.class)).setText(Component.m_237113_((String)("Grave of " + (((TileEntityGrave)entity).getGraveData() != null ? ((TileEntityGrave)entity).getGraveData().getCitizenName() : "Unknown Citizen"))));
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_DISTANCE, Text.class)).setText(Component.m_237113_((String)(distance + "m")));
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_DIRECTION, Text.class)).setText(direction);
                }
            }
        });
        ScrollingList ripList = (ScrollingList)this.findPaneOfTypeByID(LIST_CITIZEN, ScrollingList.class);
        ripList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return GraveyardManagementWindow.this.moduleView.getRestingCitizen().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                String citizenName = GraveyardManagementWindow.this.moduleView.getRestingCitizen().get(index);
                ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_CITIZEN_NAME, Text.class)).setText(Component.m_237113_((String)citizenName));
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.moduleView.cleanGraves();
    }
}

