/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.map;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MinecraftMap
extends Pane
implements AutoCloseable {
    private DynamicTexture texture;
    private ResourceLocation textureResLoc;

    public MinecraftMap() {
    }

    public MinecraftMap(PaneParams params) {
        super(params);
    }

    public void setMapData(MapItemSavedData mapData) {
        if (this.texture != null) {
            this.freeTexture();
        }
        this.texture = new DynamicTexture(128, 128, false);
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                this.texture.m_117991_().m_84988_(x, y, MaterialColor.m_192923_((int)mapData.f_77891_[x + y * 128]));
            }
        }
        this.texture.m_117985_();
        this.textureResLoc = this.mc.f_90987_.m_118490_("minecolonies_map/" + this.id, this.texture);
    }

    public void drawSelf(PoseStack ms, double mx, double my) {
        if (this.textureResLoc != null) {
            MinecraftMap.blit((PoseStack)ms, (ResourceLocation)this.textureResLoc, (int)this.x, (int)this.y, (int)this.width, (int)this.height);
        }
    }

    private void freeTexture() {
        if (this.textureResLoc != null) {
            this.texture.close();
            this.mc.f_90987_.m_118513_(this.textureResLoc);
            this.texture = null;
            this.textureResLoc = null;
        }
    }

    @Override
    public void close() {
        this.freeTexture();
    }
}

