/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.api.entity.mobs.ISpearmanMobEntity;
import com.minecolonies.api.entity.mobs.barbarians.IChiefBarbarianEntity;
import com.minecolonies.api.entity.mobs.barbarians.IMeleeBarbarianEntity;
import com.minecolonies.api.entity.mobs.egyptians.IPharaoEntity;
import com.minecolonies.api.entity.mobs.pirates.ICaptainPirateEntity;
import com.minecolonies.api.entity.mobs.pirates.IPirateEntity;
import com.minecolonies.api.entity.mobs.vikings.IMeleeNorsemenEntity;
import com.minecolonies.api.entity.mobs.vikings.INorsemenChiefEntity;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class RaiderMobUtils {
    public static double MOB_SPAWN_DEVIATION_STEPS = 0.3;
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"minecolonies");
    public static final RegistryObject<Attribute> MOB_ATTACK_DAMAGE = ATTRIBUTES.register("mc_mob_damage", () -> new RangedAttribute("mc_mob_damage", 2.0, 1.0, 20.0));
    public static int DAMAGE_PER_X_RAID_LEVEL = 400;
    public static int MAX_RAID_LEVEL_DAMAGE = 3;

    private RaiderMobUtils() {
        throw new IllegalStateException("Tried to initialize: MobSpawnUtils but this is a Utility class.");
    }

    public static void setMobAttributes(AbstractEntityMinecoloniesMob mob, IColony colony) {
        double difficultyModifier = colony.getRaiderManager().getRaidDifficultyModifier();
        mob.m_21051_(Attributes.f_22277_).m_22100_(70.0);
        mob.m_21051_(Attributes.f_22279_).m_22100_(difficultyModifier < 2.4 ? 0.25 : 0.3);
        int raidLevel = colony.getRaiderManager().getColonyRaidLevel();
        double attackDamage = 2.0 + difficultyModifier * (double)Math.min(raidLevel / DAMAGE_PER_X_RAID_LEVEL, MAX_RAID_LEVEL_DAMAGE);
        double baseHealth = RaiderMobUtils.getHealthBasedOnRaidLevel(raidLevel) * difficultyModifier;
        mob.initStatsFor(baseHealth, difficultyModifier, attackDamage);
    }

    public static double getHealthBasedOnRaidLevel(int raidLevel) {
        return Math.max(10.0, 10.0 + (double)raidLevel * 0.025);
    }

    public static void spawn(EntityType<?> entityToSpawn, int numberOfSpawns, BlockPos spawnLocation, Level world, IColony colony, int eventID) {
        if (spawnLocation != null && entityToSpawn != null && world != null && numberOfSpawns > 0) {
            int x = spawnLocation.m_123341_();
            int y = BlockPosUtil.getFloor(spawnLocation, world).m_123342_();
            int z = spawnLocation.m_123343_();
            double spawnDeviationX = 0.0;
            double spawnDeviationZ = 0.0;
            for (int i = 0; i < numberOfSpawns; ++i) {
                AbstractEntityMinecoloniesMob entity = (AbstractEntityMinecoloniesMob)entityToSpawn.m_20615_(world);
                if (entity == null) continue;
                entity.m_19890_((double)x + spawnDeviationX, (double)y + 1.0, (double)z + spawnDeviationZ, (float)Mth.m_14175_((double)(world.f_46441_.m_188500_() * 360.0)), 0.0f);
                CompatibilityUtils.addEntity(world, (Entity)entity);
                entity.setColony(colony);
                entity.setEventID(eventID);
                entity.registerWithColony();
                spawnDeviationZ += MOB_SPAWN_DEVIATION_STEPS;
                if (!(spawnDeviationZ > 2.0)) continue;
                spawnDeviationZ = 0.0;
                spawnDeviationX += MOB_SPAWN_DEVIATION_STEPS;
            }
        }
    }

    public static void setEquipment(AbstractEntityMinecoloniesMob mob) {
        if (mob instanceof IMeleeBarbarianEntity || mob instanceof IMeleeNorsemenEntity || mob instanceof INorsemenChiefEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
        } else if (mob instanceof IPharaoEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.pharaoscepter));
        } else if (mob instanceof IArcherMobEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        } else if (mob instanceof ISpearmanMobEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.spear));
        } else if (mob instanceof IChiefBarbarianEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.chiefSword));
            mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
            mob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
            mob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
            mob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
        } else if (mob instanceof IPirateEntity) {
            mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.scimitar));
            if (mob instanceof ICaptainPirateEntity) {
                if (new Random().nextBoolean()) {
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.pirateHelmet_1));
                    mob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.pirateChest_1));
                    mob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.pirateLegs_1));
                    mob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.pirateBoots_1));
                } else {
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.pirateHelmet_2));
                    mob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.pirateChest_2));
                    mob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.pirateLegs_2));
                    mob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.pirateBoots_2));
                }
            }
        }
    }

    public static List<AbstractEntityMinecoloniesMob> getBarbariansCloseToEntity(Entity entity, double distanceFromEntity) {
        return CompatibilityUtils.getWorldFromEntity(entity).m_6443_(AbstractEntityMinecoloniesMob.class, entity.m_20191_().m_82363_(distanceFromEntity, 3.0, distanceFromEntity), Entity::m_6084_);
    }
}

