/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IRecipeManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColonyManager {
    public static IColonyManager getInstance() {
        return IMinecoloniesAPI.getInstance().getColonyManager();
    }

    @Nullable
    public IColony createColony(@NotNull Level var1, BlockPos var2, @NotNull Player var3, @NotNull String var4, @NotNull String var5);

    public void deleteColonyByWorld(int var1, boolean var2, Level var3);

    public void deleteColonyByDimension(int var1, boolean var2, ResourceKey<Level> var3);

    public void removeColonyView(int var1, ResourceKey<Level> var2);

    @Nullable
    public IColony getColonyByWorld(int var1, Level var2);

    @Nullable
    public IColony getColonyByDimension(int var1, ResourceKey<Level> var2);

    public IBuilding getBuilding(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getColonyByPosFromWorld(@NotNull Level var1, @NotNull BlockPos var2);

    public IColony getColonyByPosFromDim(ResourceKey<Level> var1, @NotNull BlockPos var2);

    public boolean isFarEnoughFromColonies(@NotNull Level var1, @NotNull BlockPos var2);

    @NotNull
    public List<IColony> getColonies(@NotNull Level var1);

    @NotNull
    public List<IColony> getAllColonies();

    @NotNull
    public List<IColony> getColoniesAbandonedSince(int var1);

    public IBuildingView getBuildingView(ResourceKey<Level> var1, BlockPos var2);

    @Nullable
    public IColony getIColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getClosestIColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColonyView getClosestColonyView(@Nullable Level var1, @Nullable BlockPos var2);

    public IColony getClosestColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull Level var1, @NotNull Player var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull Level var1, UUID var2);

    public int getMinimumDistanceBetweenTownHalls();

    public void onServerTick(@NotNull TickEvent.ServerTickEvent var1);

    public void write(@NotNull CompoundTag var1);

    public void read(@NotNull CompoundTag var1);

    public void onClientTick(@NotNull TickEvent.ClientTickEvent var1);

    public void onWorldTick(@NotNull TickEvent.LevelTickEvent var1);

    public void onWorldLoad(@NotNull Level var1);

    public void setCapLoaded();

    public UUID getServerUUID();

    public void setServerUUID(UUID var1);

    public void onWorldUnload(@NotNull Level var1);

    public void handleColonyViewMessage(int var1, @NotNull FriendlyByteBuf var2, @NotNull Level var3, boolean var4, ResourceKey<Level> var5);

    public IColonyView getColonyView(int var1, ResourceKey<Level> var2);

    public void handlePermissionsViewMessage(int var1, @NotNull FriendlyByteBuf var2, ResourceKey<Level> var3);

    public void handleColonyViewCitizensMessage(int var1, int var2, FriendlyByteBuf var3, ResourceKey<Level> var4);

    public void handleColonyViewWorkOrderMessage(int var1, FriendlyByteBuf var2, ResourceKey<Level> var3);

    public void handleColonyViewRemoveCitizenMessage(int var1, int var2, ResourceKey<Level> var3);

    public void handleColonyBuildingViewMessage(int var1, BlockPos var2, @NotNull FriendlyByteBuf var3, ResourceKey<Level> var4);

    public void handleColonyViewRemoveBuildingMessage(int var1, BlockPos var2, ResourceKey<Level> var3);

    public void handleColonyViewRemoveWorkOrderMessage(int var1, int var2, ResourceKey<Level> var3);

    public boolean isSchematicDownloaded();

    public void setSchematicDownloaded(boolean var1);

    public boolean isCoordinateInAnyColony(@NotNull Level var1, BlockPos var2);

    public ICompatibilityManager getCompatibilityManager();

    public IRecipeManager getRecipeManager();

    public int getTopColonyId();

    public void resetColonyViews();

    public void openReactivationWindow(BlockPos var1);
}

