/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import com.mcwwindows.kikoz.util.WindowPart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GothicWindow
extends WindowBase {
    public static final EnumProperty<WindowPart> PART = EnumProperty.m_61587_((String)"part", WindowPart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape EAST = Shapes.m_83124_((VoxelShape)GothicWindow.m_49796_((double)3.0, (double)0.0, (double)-1.0, (double)13.0, (double)16.0, (double)17.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.m_83124_((VoxelShape)GothicWindow.m_49796_((double)-1.0, (double)0.0, (double)3.0, (double)17.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    public GothicWindow(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 3.0f).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)WindowPart.BASE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case WEST: {
                return EAST;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return NORTH;
            }
        }
        return NORTH;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, WATERLOGGED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void openDoor(Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item == ItemInit.HAMMER.get()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61122_(PART));
            return InteractionResult.SUCCESS;
        }
        Boolean open = (Boolean)state.m_61143_((Property)OPEN);
        if (open.booleanValue()) {
            this.garageDoor(worldIn, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING), 1000);
            worldIn.m_5594_(null, pos, (SoundEvent)SoundsInit.BARS_OPEN.get(), SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.m_188501_() * 0.1f + 0.8f);
            state = (BlockState)state.m_61122_((Property)OPEN);
            worldIn.m_7731_(pos, state, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_183324_().m_183582_(currentPos, (Object)Fluids.f_76193_);
        }
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76145_() : super.m_5888_(state);
    }

    private void garageDoor(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 6);
                this.garageDoor(world, pos.m_122030_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_122025_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(1).m_122030_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(1).m_122025_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(2).m_122030_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(2).m_122025_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6630_(1).m_122030_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6630_(1).m_122025_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_122020_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_122013_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(1).m_122020_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(1).m_122013_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(2).m_122020_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6625_(2).m_122013_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6630_(1).m_122020_(1), targetOpen, targetDirection, depth - 2);
                this.garageDoor(world, pos.m_6630_(1).m_122013_(1), targetOpen, targetDirection, depth - 2);
            }
        }
    }
}

