/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.structurepiececounter;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class NonFreezingMapRegistry<T>
extends WritableRegistry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenCustomHashMap(Util.m_137583_()), p_194539_ -> p_194539_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<T, Lifecycle> lifecycles = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle elementsLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    @Nullable
    private final Function<T, Holder.Reference<T>> customHolderProvider;
    @Nullable
    private Map<T, Holder.Reference<T>> intrusiveHolderCache;
    @Nullable
    private List<Holder.Reference<T>> holdersInOrder;
    private int nextId;

    public NonFreezingMapRegistry(ResourceKey<? extends Registry<T>> p_205849_, Lifecycle p_205850_, @Nullable Function<T, Holder.Reference<T>> p_205851_) {
        super(p_205849_, p_205850_);
        this.elementsLifecycle = p_205850_;
        this.customHolderProvider = p_205851_;
        if (p_205851_ != null) {
            this.intrusiveHolderCache = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    private List<Holder.Reference<T>> holdersInOrder() {
        if (this.holdersInOrder == null) {
            this.holdersInOrder = this.byId.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersInOrder;
    }

    public Holder<T> m_203704_(int p_205853_, ResourceKey<T> p_205854_, T p_205855_, Lifecycle p_205856_) {
        return this.registerMapping(p_205853_, p_205854_, p_205855_, p_205856_, true);
    }

    private Holder<T> registerMapping(int p_205858_, ResourceKey<T> p_205859_, T p_205860_, Lifecycle p_205861_, boolean p_205862_) {
        Holder.Reference reference;
        Validate.notNull(p_205859_);
        Validate.notNull(p_205860_);
        this.byId.size(Math.max(this.byId.size(), p_205858_ + 1));
        this.toId.put(p_205860_, p_205858_);
        this.holdersInOrder = null;
        if (p_205862_ && this.byKey.containsKey(p_205859_)) {
            Util.m_143785_((String)("Adding duplicate key '" + p_205859_ + "' to registry"));
        }
        if (this.byValue.containsKey(p_205860_)) {
            Util.m_143785_((String)("Adding duplicate value '" + p_205860_ + "' to registry"));
        }
        this.lifecycles.put(p_205860_, p_205861_);
        this.elementsLifecycle = this.elementsLifecycle.add(p_205861_);
        if (this.nextId <= p_205858_) {
            this.nextId = p_205858_ + 1;
        }
        if (this.customHolderProvider != null) {
            reference = this.customHolderProvider.apply(p_205860_);
            Holder.Reference reference1 = this.byKey.put(p_205859_, reference);
            if (reference1 != null && reference1 != reference) {
                throw new IllegalStateException("Invalid holder present for key " + p_205859_);
            }
        } else {
            reference = this.byKey.computeIfAbsent(p_205859_, p_205927_ -> Holder.Reference.m_205766_((Registry)this, (ResourceKey)p_205927_));
        }
        this.byLocation.put(p_205859_.m_135782_(), reference);
        this.byValue.put(p_205860_, reference);
        reference.m_205775_(p_205859_, p_205860_);
        this.byId.set(p_205858_, (Object)reference);
        return reference;
    }

    public Holder<T> m_203505_(ResourceKey<T> p_205891_, T p_205892_, Lifecycle p_205893_) {
        return this.m_203704_(this.nextId, p_205891_, p_205892_, p_205893_);
    }

    public Holder<T> m_203384_(OptionalInt p_205884_, ResourceKey<T> p_205885_, T p_205886_, Lifecycle p_205887_) {
        int i;
        Object t;
        Validate.notNull(p_205885_);
        Validate.notNull(p_205886_);
        Holder holder = (Holder)this.byKey.get(p_205885_);
        Object object = t = holder != null && holder.m_203633_() ? holder.m_203334_() : null;
        if (t == null) {
            i = p_205884_.orElse(this.nextId);
        } else {
            i = this.toId.getInt(t);
            if (p_205884_.isPresent() && p_205884_.getAsInt() != i) {
                throw new IllegalStateException("ID mismatch");
            }
            this.lifecycles.remove(t);
            this.toId.removeInt(t);
            this.byValue.remove(t);
        }
        return this.registerMapping(i, p_205885_, p_205886_, p_205887_, false);
    }

    @Nullable
    public ResourceLocation m_7981_(T p_122746_) {
        Holder.Reference<T> reference = this.byValue.get(p_122746_);
        return reference != null ? reference.m_205785_().m_135782_() : null;
    }

    public Optional<ResourceKey<T>> m_7854_(T p_122755_) {
        return Optional.ofNullable(this.byValue.get(p_122755_)).map(Holder.Reference::m_205785_);
    }

    public int m_7447_(@Nullable T p_122706_) {
        return this.toId.getInt(p_122706_);
    }

    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> p_122714_) {
        return NonFreezingMapRegistry.getValueFromNullable(this.byKey.get(p_122714_));
    }

    @Nullable
    public T m_7942_(int p_122684_) {
        return p_122684_ >= 0 && p_122684_ < this.byId.size() ? (T)NonFreezingMapRegistry.getValueFromNullable((Holder.Reference)this.byId.get(p_122684_)) : null;
    }

    public Optional<Holder<T>> m_203300_(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.byId.size() ? Optional.ofNullable((Holder)this.byId.get(p_205907_)) : Optional.empty();
    }

    public Optional<Holder<T>> m_203636_(ResourceKey<T> p_205905_) {
        return Optional.ofNullable((Holder)this.byKey.get(p_205905_));
    }

    public DataResult<Holder<T>> m_214185_(ResourceKey<T> p_235720_) {
        Holder.Reference reference = this.byKey.get(p_235720_);
        if (reference == null) {
            if (this.customHolderProvider != null) {
                return DataResult.error((String)("This registry can't create new holders without value (requested key: " + p_235720_ + ")"));
            }
            reference = Holder.Reference.m_205766_((Registry)this, p_235720_);
            this.byKey.put(p_235720_, reference);
        }
        return DataResult.success(reference);
    }

    public int m_13562_() {
        return this.byKey.size();
    }

    public Lifecycle m_6228_(T p_122764_) {
        return this.lifecycles.get(p_122764_);
    }

    public Lifecycle m_7837_() {
        return this.elementsLifecycle;
    }

    public Iterator<T> iterator() {
        return Iterators.transform(this.holdersInOrder().iterator(), Holder::m_203334_);
    }

    @Nullable
    public T m_7745_(@Nullable ResourceLocation p_122739_) {
        Holder.Reference<T> reference = this.byLocation.get(p_122739_);
        return NonFreezingMapRegistry.getValueFromNullable(reference);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> p_205866_) {
        return (T)(p_205866_ != null ? p_205866_.m_203334_() : null);
    }

    public Set<ResourceLocation> m_6566_() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::m_203334_).entrySet());
    }

    public Set<ResourceKey<T>> m_214010_() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    public Stream<Holder.Reference<T>> m_203611_() {
        return this.holdersInOrder().stream();
    }

    public boolean m_203658_(TagKey<T> p_205864_) {
        return this.tags.containsKey(p_205864_);
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> m_203612_() {
        return this.tags.entrySet().stream().map(p_211060_ -> Pair.of((Object)((TagKey)p_211060_.getKey()), (Object)((HolderSet.Named)p_211060_.getValue())));
    }

    public HolderSet.Named<T> m_203561_(TagKey<T> p_205895_) {
        HolderSet.Named<T> named = this.tags.get(p_205895_);
        if (named == null) {
            named = this.createTag(p_205895_);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(p_205895_, named);
            this.tags = map;
        }
        return named;
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named((Registry)this, p_211068_);
    }

    public Stream<TagKey<T>> m_203613_() {
        return this.tags.keySet().stream();
    }

    public boolean m_142427_() {
        return this.byKey.isEmpty();
    }

    public Optional<Holder<T>> m_213642_(RandomSource p_205889_) {
        return Util.m_214676_(this.holdersInOrder(), (RandomSource)p_205889_).map(Holder::m_205706_);
    }

    public boolean m_7804_(ResourceLocation p_122761_) {
        return this.byLocation.containsKey(p_122761_);
    }

    public boolean m_142003_(ResourceKey<T> p_175392_) {
        return this.byKey.containsKey(p_175392_);
    }

    @Deprecated
    public void unfreeze() {
        if (this.customHolderProvider != null && this.intrusiveHolderCache == null) {
            this.intrusiveHolderCache = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    public Registry<T> m_203521_() {
        List<ResourceLocation> list = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).m_203633_()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).m_135782_()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.m_123023_() + ": " + list);
        }
        if (this.intrusiveHolderCache != null) {
            List<Holder.Reference> list1 = this.intrusiveHolderCache.values().stream().filter(p_211809_ -> !p_211809_.m_203633_()).toList();
            if (!list1.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not added to registry: " + list1);
            }
            this.intrusiveHolderCache = null;
        }
        return this;
    }

    public Holder<T> m_214121_(ResourceKey<T> p_235795_) {
        return (Holder)this.byKey.computeIfAbsent(p_235795_, p_235723_ -> {
            if (this.customHolderProvider != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            return Holder.Reference.m_205766_((Registry)this, (ResourceKey)p_235723_);
        });
    }

    public Holder.Reference<T> m_203693_(T p_205915_) {
        if (this.customHolderProvider == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        if (this.intrusiveHolderCache != null) {
            return this.intrusiveHolderCache.computeIfAbsent(p_205915_, p_211813_ -> Holder.Reference.m_205763_((Registry)this, (Object)p_211813_));
        }
        throw new IllegalStateException("Registry is already frozen");
    }

    public Optional<HolderSet.Named<T>> m_203431_(TagKey<T> p_205909_) {
        return Optional.ofNullable(this.tags.get(p_205909_));
    }

    public void m_203652_(Map<TagKey<T>, List<Holder<T>>> p_205875_) {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        p_205875_.forEach((p_211806_, p_211807_) -> {
            for (Holder holder : p_211807_) {
                if (!holder.m_203401_((Registry)this)) {
                    throw new IllegalStateException("Can't create named set " + p_211806_ + " containing value " + holder + " from outside registry " + this);
                }
                if (!(holder instanceof Holder.Reference)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + p_211806_);
                }
                Holder.Reference reference = (Holder.Reference)holder;
                ((List)map.get(reference)).add(p_211806_);
            }
        });
        Sets.SetView set = Sets.difference(this.tags.keySet(), p_205875_.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", (Object)this.m_123023_(), (Object)set.stream().map(p_211811_ -> p_211811_.f_203868_().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map1 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        p_205875_.forEach((p_211797_, p_211798_) -> map1.computeIfAbsent((TagKey<T>)p_211797_, this::createTag).m_205835_(p_211798_));
        map.forEach(Holder.Reference::m_205769_);
        this.tags = map1;
    }

    public void m_203635_() {
        this.tags.values().forEach(p_211792_ -> p_211792_.m_205835_(List.of()));
        this.byKey.values().forEach(p_211803_ -> p_211803_.m_205769_(Set.of()));
    }
}

