/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.pooladditions;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.misc.structurepiececounter.JSONConditionsRegistry;
import com.craisinlord.integrated_api.mixin.structures.ListPoolElementAccessor;
import com.craisinlord.integrated_api.mixin.structures.SinglePoolElementAccessor;
import com.craisinlord.integrated_api.mixin.structures.StructurePoolAccessor;
import com.craisinlord.integrated_api.mixin.structures.StructureTemplateManagerAccessor;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.server.ServerAboutToStartEvent;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "integrated_structure_pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools(ServerAboutToStartEvent event) {
        ResourceManager resourceManager = ((StructureTemplateManagerAccessor)event.getServer().m_236738_()).integrated_api_getResourceManager();
        Map<ResourceLocation, List<JsonElement>> poolAdditionJSON = GeneralUtils.getAllDatapacksJSONElement(resourceManager, GSON, DATA_TYPE, FILE_SUFFIX_LENGTH);
        PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, (RegistryAccess)event.getServer().m_206579_(), event.getServer().m_236738_());
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, List<JsonElement>> poolAdditionJSON, RegistryAccess dynamicRegistryManager, StructureTemplateManager StructureTemplateManager2) {
        Registry poolRegistry = dynamicRegistryManager.m_206191_(Registry.f_122884_);
        RegistryOps customRegistryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)dynamicRegistryManager);
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.m_7745_(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                try {
                    AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (StructureTemplatePool)poolRegistry.m_7745_((ResourceLocation)entry.getKey()), StructureTemplateManager2));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error("\nIntegratedAPI: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), poolRegistry, e.getMessage()).indent(1));
                }
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, StructureTemplatePool gluttonyPool, StructureTemplateManager StructureTemplateManager2) {
        ObjectArrayList elements = new ObjectArrayList(((StructurePoolAccessor)gluttonyPool).integrated_api_getTemplates());
        ArrayList<Pair<StructurePoolElement, Integer>> elementCounts = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)gluttonyPool).integrated_api_getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).integrated_api_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).integrated_api_getRawTemplates());
        for (StructurePoolElement element : elements) {
            if (element instanceof SinglePoolElement) {
                Optional structureTemplate;
                SinglePoolElement singlePoolElement = (SinglePoolElement)element;
                Optional nbtID = ((SinglePoolElementAccessor)singlePoolElement).integrated_api_getTemplate().left();
                if (nbtID.isEmpty() || !(structureTemplate = StructureTemplateManager2.m_230407_((ResourceLocation)nbtID.get())).isEmpty()) continue;
                IntegratedAPI.LOGGER.error("(IntegratedAPI POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_210587_(), nbtID.get());
                continue;
            }
            if (!(element instanceof ListPoolElement)) continue;
            ListPoolElement listPoolElement = (ListPoolElement)element;
            for (StructurePoolElement listElement : ((ListPoolElementAccessor)listPoolElement).integrated_api_getElements()) {
                Optional structureTemplate;
                SinglePoolElement singlePoolElement;
                Optional nbtID;
                if (!(listElement instanceof SinglePoolElement) || (nbtID = ((SinglePoolElementAccessor)(singlePoolElement = (SinglePoolElement)listElement)).integrated_api_getTemplate().left()).isEmpty() || !(structureTemplate = StructureTemplateManager2.m_230407_((ResourceLocation)nbtID.get())).isEmpty()) continue;
                IntegratedAPI.LOGGER.error("(IntegratedAPI POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_210587_(), nbtID.get());
            }
        }
        ((StructurePoolAccessor)gluttonyPool).integrated_api_setTemplates((ObjectArrayList<StructurePoolElement>)elements);
        ((StructurePoolAccessor)gluttonyPool).integrated_api_setRawTemplates(elementCounts);
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        IntegratedAPI.LOGGER.error("(IntegratedAPI POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends StructureTemplatePool {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.f_210468_.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)ResourceLocation.f_135803_.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(StructureTemplatePool::m_210587_), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(StructureTemplatePool::m_210573_), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;

        public AdditionalStructureTemplatePool(ResourceLocation resourceLocation, ResourceLocation resourceLocation2, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(resourceLocation, resourceLocation2, rawTemplatesWithConditions.stream().filter(triple -> {
                if (triple.condition().isPresent()) {
                    Optional optionalSupplier = JSONConditionsRegistry.IntegratedAPI_JSON_CONDITIONS_REGISTRY.m_6612_(triple.condition.get());
                    if (optionalSupplier.isPresent()) {
                        return (Boolean)((Supplier)optionalSupplier.get()).get();
                    }
                    IntegratedAPI.LOGGER.error("IntegratedAPI Error: Found {} entry has a condition that does not exist. Extra info: {}", (Object)resourceLocation, (Object)resourceLocation2);
                }
                return true;
            }).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
        }

        public record ExpandedPoolEntry(StructurePoolElement poolElement, Integer weight, Optional<ResourceLocation> condition) {
        }
    }
}

