/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.incubation.core.other.tags.IncubationBiomeTags;
import com.teamabnormals.incubation.core.registry.IncubationFeatures;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class IncubationBiomeModifierProvider {
    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Writable access = RegistryAccess.m_206197_();
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Registry placedFeatures = access.m_175515_(Registry.f_194567_);
        HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
        IncubationBiomeModifierProvider.addModifier(modifiers, "add_feature/chicken_nest", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(IncubationBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, IncubationBiomeTags.HAS_CHICKEN_NEST), IncubationBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, IncubationFeatures.IncubationPlacedFeatures.NEST_CHICKEN), GenerationStep.Decoration.VEGETAL_DECORATION));
        IncubationBiomeModifierProvider.addModifier(modifiers, "add_feature/duck_nest", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(IncubationBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, IncubationBiomeTags.HAS_DUCK_NEST), IncubationBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, IncubationFeatures.IncubationPlacedFeatures.NEST_DUCK), GenerationStep.Decoration.VEGETAL_DECORATION));
        IncubationBiomeModifierProvider.addModifier(modifiers, "add_feature/turkey_nest", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(IncubationBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, IncubationBiomeTags.HAS_TURKEY_NEST), IncubationBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, IncubationFeatures.IncubationPlacedFeatures.NEST_TURKEY), GenerationStep.Decoration.VEGETAL_DECORATION));
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"incubation", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static HolderSet<Biome> tag(Registry<Biome> biomeRegistry, TagKey<Biome> tagKey) {
        return new HolderSet.Named(biomeRegistry, tagKey);
    }

    private static void addModifier(HashMap<ResourceLocation, BiomeModifier> modifiers, String name, BiomeModifier modifier) {
        modifiers.put(new ResourceLocation("incubation", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> of(Registry<PlacedFeature> placedFeatures, RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

