/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ItemHoldingBlockEntity
extends BlockEntity {
    private ItemStack item = ItemStack.f_41583_;

    public ItemHoldingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Item", (Tag)this.item.m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        this.item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
    }

    public ItemStack getStack() {
        return this.item;
    }

    public void setStack(ItemStack item) {
        this.item = item;
        this.update();
    }

    public void clear() {
        this.setStack(ItemStack.f_41583_);
    }

    public void update() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static InteractionResult placeItem(Level level, BlockPos pos, Player player, ItemStack defaultItem, Predicate<ItemStack> filter, SoundEvent sound) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ItemHoldingBlockEntity) {
            ItemHoldingBlockEntity entity = (ItemHoldingBlockEntity)blockEntity;
            ItemStack stack = player.m_21205_();
            if (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)defaultItem) && (entity.getStack().m_41619_() || ItemStack.m_41746_((ItemStack)entity.getStack(), (ItemStack)defaultItem)) && filter.test(stack)) {
                if (!level.f_46443_) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    entity.setStack(copy);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                player.m_216990_(sound);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6047_() && !ItemStack.m_41746_((ItemStack)entity.getStack(), (ItemStack)defaultItem)) {
                if (!level.f_46443_) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.getStack());
                    entity.setStack(defaultItem);
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.5));
                    level.m_7967_((Entity)itemEntity);
                    return InteractionResult.CONSUME;
                }
                if (!entity.getStack().m_41619_()) {
                    player.m_216990_(sound);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.CONSUME;
    }
}

