/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.forge;

import dev.architectury.platform.forge.EventBuses;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.FTBQuestsTags;
import dev.ftb.mods.ftbquests.command.ChangeProgressArgument;
import dev.ftb.mods.ftbquests.command.QuestObjectArgument;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeEnergyTask;
import java.util.Iterator;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ftbquests")
public class FTBQuestsForge {
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registry.f_235724_, (String)"ftbteams");
    private static final RegistryObject<SingletonArgumentInfo<ChangeProgressArgument>> CHANGE_PROGRESS = COMMAND_ARGUMENT_TYPES.register("change_progress", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(ChangeProgressArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(ChangeProgressArgument::changeProgress)));
    private static final RegistryObject<SingletonArgumentInfo<QuestObjectArgument>> QUEST_OBJECT = COMMAND_ARGUMENT_TYPES.register("quest_object", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QuestObjectArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(QuestObjectArgument::new)));

    public FTBQuestsForge() {
        EventBuses.registerModEventBus((String)"ftbquests", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBQuests quests = new FTBQuests();
        ForgeEnergyTask.TYPE = TaskTypes.register(new ResourceLocation("ftbquests", "forge_energy"), ForgeEnergyTask::new, () -> Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString())));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> quests.setup());
        MinecraftForge.EVENT_BUS.addListener(FTBQuestsForge::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, FTBQuestsForge::dropsEvent);
    }

    private static void livingDrops(LivingDropsEvent event) {
        LivingEntity e = event.getEntity();
        if (e.f_19853_.f_46443_ || e instanceof Player || e.m_6095_().m_204039_(FTBQuestsTags.EntityTypes.NO_LOOT_CRATES)) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.dropLootCrates) {
            return;
        }
        LootCrate crate = ServerQuestFile.INSTANCE.getRandomLootCrate((Entity)e, e.f_19853_.f_46441_);
        if (crate != null) {
            ItemEntity ei = new ItemEntity(e.f_19853_, e.m_20185_(), e.m_20186_(), e.m_20189_(), crate.createStack());
            ei.m_32010_(10);
            event.getDrops().add(ei);
        }
    }

    private static void dropsEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (player instanceof FakePlayer || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity drop = (ItemEntity)iterator.next();
            ItemStack stack = drop.m_32055_();
            if (stack.m_41720_() != FTBQuestsItems.BOOK.get() || !player.m_36356_(stack)) continue;
            iterator.remove();
        }
    }
}

