/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.clusters;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import zed.d0c.floormats.blocks.AbstractFloorMatBlock;
import zed.d0c.floormats.clusters.Clusters;

public class ClustersNode
implements INBTSerializable<CompoundTag> {
    private final Block cnBlock;
    private final HashSet<UUID> cnUUID_Set = new HashSet();
    private final HashMap<BlockPos, Boolean> cnNodeMap = new HashMap();
    private UUID cnID;
    UUID cnLink;
    private UUID cnLinkBack;
    private int cnBitFlags;
    static final HashMap<UUID, ClustersNode> idRegistry = new HashMap();
    private static final String BLOCK_TYPE_KEY = "cnBlockName";
    private static final String NODE_MAP_KEY = "cnNodeMap";
    private static final String LIST_UUID_KEY = "cnListUUID";
    private static final String ID_KEY = "cnID";
    private static final String LINK_KEY = "cnLink";
    private static final String LINK_BACK_KEY = "cnLinkBack";
    private static final String BIT_FLAGS_KEY = "cnBitFlags";
    protected static final Random random = new Random();
    private static final int BF_MUTED = 1;
    private static final int BF_INVERTED = 2;

    ClustersNode(Block blockType, HashSet<UUID> uuidSet) {
        this.cnBlock = blockType;
        this.cnUUID_Set.addAll(uuidSet);
    }

    ClustersNode(Block block, BlockPos pos) {
        BlockPos iPos = pos.m_7949_();
        this.cnBlock = block;
        this.cnNodeMap.put(iPos, false);
    }

    public ClustersNode(CompoundTag entry) {
        this.cnBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_128461_(BLOCK_TYPE_KEY)));
        this.deserializeNBT(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            nbt.m_128359_(BLOCK_TYPE_KEY, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.cnBlock)).toString());
            if (this.cnID != null) {
                nbt.m_128362_(ID_KEY, this.cnID);
            }
            if (this.cnLink != null) {
                nbt.m_128362_(LINK_KEY, this.cnLink);
                nbt.m_128362_(LINK_BACK_KEY, this.cnLinkBack);
            }
            if (!this.cnUUID_Set.isEmpty()) {
                ListTag uuidLNBT = new ListTag();
                for (UUID u : this.cnUUID_Set) {
                    CompoundTag cNBT = new CompoundTag();
                    cNBT.m_128362_("", u);
                    uuidLNBT.add((Object)cNBT);
                }
                nbt.m_128365_(LIST_UUID_KEY, (Tag)uuidLNBT);
            }
            CompoundTag nodeMapNBT = new CompoundTag();
            for (BlockPos key : this.cnNodeMap.keySet()) {
                nodeMapNBT.m_128379_(Long.toString(key.m_121878_()), this.cnNodeMap.get(key).booleanValue());
            }
            nbt.m_128365_(NODE_MAP_KEY, (Tag)nodeMapNBT);
            if (this.cnBitFlags != 0) {
                nbt.m_128405_(BIT_FLAGS_KEY, this.cnBitFlags);
            }
        }
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundTag entry) {
        if (entry.m_128403_(ID_KEY)) {
            this.cnID = entry.m_128342_(ID_KEY);
            idRegistry.put(this.cnID, this);
        }
        if (entry.m_128403_(LINK_KEY)) {
            this.cnLink = entry.m_128342_(LINK_KEY);
            this.cnLinkBack = entry.m_128342_(LINK_BACK_KEY);
        }
        ListTag uuidLNBT = entry.m_128437_(LIST_UUID_KEY, 10);
        for (int index = 0; index < uuidLNBT.size(); ++index) {
            this.cnUUID_Set.add(uuidLNBT.m_128728_(index).m_128342_(""));
        }
        CompoundTag nodeMapNBT = entry.m_128469_(NODE_MAP_KEY);
        for (String key : nodeMapNBT.m_128431_()) {
            this.cnNodeMap.put(BlockPos.m_122022_((long)Long.parseLong(key)), nodeMapNBT.m_128471_(key));
        }
        this.cnBitFlags = entry.m_128451_(BIT_FLAGS_KEY);
    }

    public Block getNodeBlockType() {
        return this.cnBlock;
    }

    private UUID getID() {
        if (this.cnID != null) {
            return this.cnID;
        }
        this.cnID = UUID.randomUUID();
        idRegistry.put(this.cnID, this);
        return this.cnID;
    }

    public boolean isEmpty() {
        return this.cnNodeMap.isEmpty();
    }

    boolean contains(Block block, BlockPos pos) {
        if (block == this.cnBlock) {
            return this.cnNodeMap.containsKey(pos);
        }
        return false;
    }

    private void broadcastToNeighbors(Level worldIn, HashSet<BlockPos> posToBroadcast) {
        BlockPos anyPos = (BlockPos)posToBroadcast.toArray()[0];
        if (ForgeEventFactory.onNeighborNotify((Level)worldIn, (BlockPos)anyPos, (BlockState)worldIn.m_8055_(anyPos), EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        for (BlockPos pos : posToBroadcast) {
            BlockState state = worldIn.m_8055_(pos);
            Block block = state.m_60734_();
            worldIn.m_46586_(pos.m_122024_(), block, pos);
            worldIn.m_46586_(pos.m_122029_(), block, pos);
            worldIn.m_46586_(pos.m_7495_(), block, pos);
            worldIn.m_46586_(pos.m_7494_(), block, pos);
            worldIn.m_46586_(pos.m_122012_(), block, pos);
            worldIn.m_46586_(pos.m_122019_(), block, pos);
            BlockPos downPos = pos.m_7495_();
            BlockState downState = worldIn.m_8055_(downPos);
            Block downBlock = downState.m_60734_();
            worldIn.m_46586_(downPos.m_122024_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122029_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_7495_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122012_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122019_(), downBlock, downPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean powerNode(Level worldIn, @Nullable BlockPos iPos, @Nullable ArrayList<Player> playerList) {
        if (iPos == null || !this.cnNodeMap.get(iPos).booleanValue()) {
            if (playerList != null && !this.cnUUID_Set.isEmpty() && playerList.stream().noneMatch(player -> this.isInverted() ^ this.cnUUID_Set.contains(player.m_20148_()))) {
                return false;
            }
            HashSet<BlockPos> posToUpdate = new HashSet<BlockPos>(this.cnNodeMap.keySet());
            ClustersNode clustersNode = this;
            synchronized (clustersNode) {
                boolean alreadyPowered = this.isPowered();
                if (iPos != null) {
                    this.cnNodeMap.put(iPos, true);
                }
                if (!alreadyPowered) {
                    this.playClickOnSound(worldIn, iPos);
                    loopParser loop = new loopParser(this);
                    do {
                        HashSet<BlockPos> posToPower = new HashSet<BlockPos>(loop.get().cnNodeMap.keySet());
                        posToUpdate.addAll(posToPower);
                        for (BlockPos activatePos : posToPower) {
                            BlockState state = worldIn.m_8055_(activatePos);
                            if (state.m_60734_() instanceof AbstractFloorMatBlock) {
                                worldIn.m_46597_(activatePos, (BlockState)state.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                                continue;
                            }
                            loop.get().cnNodeMap.remove(activatePos);
                        }
                    } while (loop.next());
                }
            }
            this.broadcastToNeighbors(worldIn, posToUpdate);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void depowerNode(Level worldIn) {
        HashSet<BlockPos> posToUpdate = new HashSet<BlockPos>();
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            loopParser loop = new loopParser(this);
            do {
                HashSet<BlockPos> posToDepower = new HashSet<BlockPos>(loop.get().cnNodeMap.keySet());
                posToUpdate.addAll(posToDepower);
                for (BlockPos deactivatePos : posToDepower) {
                    BlockState oldState = worldIn.m_8055_(deactivatePos);
                    if (oldState.m_60734_() instanceof AbstractFloorMatBlock) {
                        worldIn.m_46597_(deactivatePos, (BlockState)oldState.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    loop.get().cnNodeMap.remove(deactivatePos);
                }
            } while (loop.next());
        }
        this.broadcastToNeighbors(worldIn, posToUpdate);
    }

    boolean isPowered() {
        loopParser loop = new loopParser(this);
        do {
            if (!loop.get().cnNodeMap.containsValue(true)) continue;
            return true;
        } while (loop.next());
        return false;
    }

    boolean depowerBlock(Level worldIn, BlockPos pos) {
        this.cnNodeMap.replace(pos, false);
        if (this.isPowered()) {
            return false;
        }
        this.depowerNode(worldIn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void absorbOtherNode(ClustersNode otherNode) {
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            this.cnUUID_Set.addAll(otherNode.cnUUID_Set);
            this.cnNodeMap.putAll(otherNode.cnNodeMap);
            if (!(this.isLinked(otherNode) || this.cnLink == null && otherNode.cnLink == null)) {
                this.linkTo(otherNode);
            }
            if (this.cnLink != null) {
                ClustersNode.idRegistry.get((Object)otherNode.cnLinkBack).cnLink = otherNode.cnLink;
                ClustersNode.idRegistry.get((Object)otherNode.cnLink).cnLinkBack = otherNode.cnLinkBack;
                if (this.cnLink == this.cnID) {
                    this.cnID = null;
                    this.cnLink = null;
                    this.cnLinkBack = null;
                }
            }
        }
    }

    boolean isLinked(ClustersNode otherNode) {
        if (this.cnLink == null || otherNode.cnLink == null) {
            return false;
        }
        UUID otherID = otherNode.getID();
        loopParser loop = new loopParser(this);
        do {
            if (!loop.get().cnLink.equals(otherID)) continue;
            return true;
        } while (loop.next());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePos(Level worldIn, BlockPos pos) {
        Boolean wasPowered;
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            wasPowered = this.cnNodeMap.get(pos);
            this.cnNodeMap.remove(pos);
        }
        if (wasPowered.booleanValue() && !this.isPowered()) {
            this.depowerNode(worldIn);
        }
    }

    public Clusters.ClustersSet reformNode(Level worldIn) {
        Clusters.ClustersSet returnDistinctNodes = new Clusters.ClustersSet();
        Block blockType = this.getNodeBlockType();
        while (this.cnNodeMap.size() > 0) {
            ClustersNode newNode = new ClustersNode(blockType, this.cnUUID_Set);
            HashSet<BlockPos> posToAdd = new HashSet<BlockPos>();
            BlockPos anyKey = (BlockPos)this.cnNodeMap.keySet().toArray()[0];
            posToAdd.add(anyKey.m_7949_());
            while (posToAdd.size() > 0) {
                BlockPos nextPos = (BlockPos)posToAdd.toArray()[0];
                posToAdd.remove(nextPos);
                newNode.cnNodeMap.put(nextPos.m_7949_(), this.cnNodeMap.remove(nextPos));
                BlockState state = worldIn.m_8055_(nextPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos adjacentPos;
                    if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue() || !this.cnNodeMap.containsKey(adjacentPos = nextPos.m_121945_(direction))) continue;
                    posToAdd.add(adjacentPos.m_7949_());
                }
            }
            returnDistinctNodes.add(newNode);
        }
        if (this.cnLink != null) {
            for (ClustersNode node : returnDistinctNodes) {
                node.cnLinkBack = this.cnLinkBack;
                ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = node.getID();
                this.cnLinkBack = node.cnID;
            }
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.cnLink;
            ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = this.cnLinkBack;
        }
        return returnDistinctNodes;
    }

    public void powerAsNeeded(Level worldIn) {
        if (this.isPowered()) {
            HashSet<BlockPos> poweredBPSet = new HashSet<BlockPos>();
            for (BlockPos pos : this.cnNodeMap.keySet()) {
                BlockState state = worldIn.m_8055_(pos);
                if (((Boolean)state.m_61143_((Property)AbstractFloorMatBlock.POWERED)).booleanValue()) continue;
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                poweredBPSet.add(pos);
            }
            if (!poweredBPSet.isEmpty()) {
                this.broadcastToNeighbors(worldIn, poweredBPSet);
            }
        }
    }

    public void addUniqueID(UUID uniqueID) {
        this.cnUUID_Set.add(uniqueID);
    }

    public boolean canAccess(UUID uniqueID) {
        return this.cnUUID_Set.isEmpty() || this.cnUUID_Set.contains(uniqueID);
    }

    public int cmdResetNode(ServerLevel serverWorld) {
        HashSet<BlockPos> failedPosSet = new HashSet<BlockPos>();
        for (BlockPos posToCheck : this.cnNodeMap.keySet()) {
            if (serverWorld.m_8055_(posToCheck).m_60734_() == this.cnBlock) continue;
            failedPosSet.add(posToCheck);
        }
        for (BlockPos posToCull : failedPosSet) {
            this.cnNodeMap.remove(posToCull);
        }
        return failedPosSet.size();
    }

    public void removeLink(Level worldIn, boolean wasPowered) {
        if (this.cnLink != null) {
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.cnLink;
            ClustersNode node = idRegistry.get(this.cnLink);
            node.cnLinkBack = this.cnLinkBack;
            node.verifyLink();
            this.wipeLink();
            if (wasPowered && !this.isPowered()) {
                this.depowerNode(worldIn);
            } else if (wasPowered && !node.isPowered()) {
                node.depowerNode(worldIn);
            }
        }
    }

    private void wipeLink() {
        this.cnID = null;
        this.cnLink = null;
        this.cnLinkBack = null;
    }

    private void verifyLink() {
        if (this.cnLink == this.cnID) {
            this.wipeLink();
        }
    }

    public void linkTo(ClustersNode linkNode) {
        if (linkNode.cnLink == null) {
            if (this.cnLink == null) {
                linkNode.cnLink = this.getID();
                this.cnLinkBack = linkNode.getID();
            } else {
                linkNode.cnLink = this.cnLink;
                ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = linkNode.getID();
            }
        } else if (this.cnLink == null) {
            this.cnLinkBack = linkNode.cnLinkBack;
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.getID();
        } else {
            ClustersNode.idRegistry.get((Object)linkNode.cnLinkBack).cnLink = this.cnLink;
            ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = linkNode.cnLinkBack;
        }
        this.cnLink = linkNode.cnID;
        linkNode.cnLinkBack = this.cnID;
    }

    public void createLinkEffect(Level worldIn) {
        for (BlockPos pos : this.cnNodeMap.keySet()) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (int i = 0; i < 8; ++i) {
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)x + random.nextDouble(), (double)y + random.nextDouble(), (double)z + random.nextDouble(), 1, 0.0, 0.4, 0.0, (double)0.15f);
            }
        }
    }

    public boolean hasDirectPowerMarked(BlockPos pos) {
        return this.cnNodeMap.get(pos);
    }

    boolean isInverted() {
        return (this.cnBitFlags & 2) != 0;
    }

    public void toggleInverted() {
        this.cnBitFlags ^= 2;
    }

    boolean isMuffled() {
        return (this.cnBitFlags & 1) != 0;
    }

    public void toggleMuffler() {
        this.cnBitFlags ^= 1;
    }

    public void clearPlayerList() {
        this.cnUUID_Set.clear();
    }

    public void playClickOnSound(Level worldIn, BlockPos pos) {
        if (this.isMuffled()) {
            return;
        }
        Material material = this.cnBlock.m_49966_().m_60767_();
        if (material.equals(Material.f_76320_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 0.3f, 0.8f);
        } else if (material.equals(Material.f_76278_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12449_, SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (material.equals(Material.f_76279_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12067_, SoundSource.BLOCKS, 0.3f, 0.90000004f);
        }
    }

    public void playClickOffSound(Level worldIn, BlockPos pos) {
        if (this.isMuffled()) {
            return;
        }
        Material material = this.cnBlock.m_49966_().m_60767_();
        if (material.equals(Material.f_76320_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12636_, SoundSource.BLOCKS, 0.3f, 0.8f);
        } else if (material.equals(Material.f_76278_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12448_, SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (material.equals(Material.f_76279_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12066_, SoundSource.BLOCKS, 0.3f, 0.90000004f);
        }
    }

    private static class loopParser {
        private final HashSet<ClustersNode> usedNodes = new HashSet();
        private ClustersNode cursor;

        loopParser(ClustersNode start) {
            this.cursor = start;
        }

        ClustersNode get() {
            return this.cursor;
        }

        boolean next() {
            this.usedNodes.add(this.cursor);
            if (this.cursor.cnLink != null) {
                this.cursor = idRegistry.get(this.cursor.cnLink);
            }
            return !this.usedNodes.contains(this.cursor);
        }
    }
}

