/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementGroupScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ConfirmationScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageRequirementsScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer container;
    protected Consumer<LoadingRequirementContainer> callback;
    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected AdvancedButton addRequirementButton;
    protected AdvancedButton addGroupButton;
    protected AdvancedButton editButton;
    protected AdvancedButton removeButton;
    protected AdvancedButton doneButton;

    public ManageRequirementsScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer container, @NotNull Consumer<LoadingRequirementContainer> callback) {
        super((Component)Component.m_237113_((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.manage", (String[])new String[0])));
        this.parentScreen = parentScreen;
        this.container = container;
        this.callback = callback;
        this.updateRequirementsScrollArea();
        this.addRequirementButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (String[])new String[0]), true, button -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addInstance((LoadingRequirementInstance)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.addRequirementButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_requirement.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addRequirementButton);
        this.addGroupButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_group", (String[])new String[0]), true, button -> {
            BuildRequirementGroupScreen s = new BuildRequirementGroupScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addGroup((LoadingRequirementGroup)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.addGroupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_group.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addGroupButton);
        this.editButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            Screen s = null;
            if (this.isInstanceSelected()) {
                s = new BuildRequirementScreen(this, this.container, this.getSelectedInstance(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            } else if (this.isGroupSelected()) {
                s = new BuildRequirementGroupScreen(this, this.container, this.getSelectedGroup(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            }
            if (s != null) {
                Minecraft.m_91087_().m_91152_(s);
            }
        }){

            public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editButton);
        this.removeButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            ConfirmationScreen s = null;
            if (this.isInstanceSelected()) {
                LoadingRequirementInstance i = this.getSelectedInstance();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement.confirm", (String[])new String[0]), (String)"%n%"));
            } else if (this.isGroupSelected()) {
                LoadingRequirementGroup g = this.getSelectedGroup();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeGroup(g);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group.confirm", (String[])new String[0]), (String)"%n%"));
            }
            if (s != null) {
                Minecraft.m_91087_().m_91152_(s);
            }
        }){

            public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.removeButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.container);
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
    }

    protected void m_7856_() {
        Minecraft.m_91087_().m_91268_().m_85378_((double)Minecraft.m_91087_().m_91268_().m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        super.m_7856_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        this.callback.accept(this.container);
    }

    public void m_6305_(@NotNull PoseStack matrix, int mouseX, int mouseY, float partial) {
        ManageRequirementsScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        this.f_96547_.m_92889_(matrix, (Component)titleComp, 20.0f, 20.0f, -1);
        this.f_96547_.m_92883_(matrix, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups", (String[])new String[0]), 20.0f, 50.0f, -1);
        this.requirementsScrollArea.setWidth(this.f_96543_ - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.f_96544_ - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(65, true);
        this.requirementsScrollArea.render(matrix, mouseX, mouseY, partial);
        this.doneButton.setX(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.setY(this.f_96544_ - 20 - 20);
        this.doneButton.m_6305_(matrix, mouseX, mouseY, partial);
        this.removeButton.setX(this.f_96543_ - 20 - this.removeButton.m_5711_());
        this.removeButton.setY(this.doneButton.getY() - 15 - 20);
        this.removeButton.m_6305_(matrix, mouseX, mouseY, partial);
        this.editButton.setX(this.f_96543_ - 20 - this.editButton.m_5711_());
        this.editButton.setY(this.removeButton.getY() - 5 - 20);
        this.editButton.m_6305_(matrix, mouseX, mouseY, partial);
        this.addGroupButton.setX(this.f_96543_ - 20 - this.addGroupButton.m_5711_());
        this.addGroupButton.setY(this.editButton.getY() - 5 - 20);
        this.addGroupButton.m_6305_(matrix, mouseX, mouseY, partial);
        this.addRequirementButton.setX(this.f_96543_ - 20 - this.addRequirementButton.m_5711_());
        this.addRequirementButton.setY(this.addGroupButton.getY() - 5 - 20);
        this.addRequirementButton.m_6305_(matrix, mouseX, mouseY, partial);
        super.m_6305_(matrix, mouseX, mouseY, partial);
    }

    @Nullable
    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementInstanceEntry) {
            return ((RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    @Nullable
    protected LoadingRequirementGroup getSelectedGroup() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementGroupEntry) {
            return ((RequirementGroupEntry)e).group;
        }
        return null;
    }

    protected boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    protected void updateRequirementsScrollArea() {
        ScrollAreaEntry e;
        this.requirementsScrollArea.clearEntries();
        for (LoadingRequirementGroup g : this.container.getGroups()) {
            e = new RequirementGroupEntry(this.requirementsScrollArea, g);
            this.requirementsScrollArea.addEntry(e);
        }
        for (LoadingRequirementInstance i : this.container.getInstances()) {
            e = new RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }
    }

    public static class RequirementInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementInstance instance;
        public final int lineHeight;
        public Font font;
        private MutableComponent displayNameComponent;
        private MutableComponent modeComponent;
        private MutableComponent valueComponent;

        public RequirementInstanceEntry(ScrollArea parent, LoadingRequirementInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = Minecraft.m_91087_().f_91062_;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = Component.m_237113_((String)this.instance.requirement.getDisplayName()).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB()));
            String modeString = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.normal", (String[])new String[0]) : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.opposite", (String[])new String[0]);
            this.modeComponent = Component.m_237113_((String)(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode", (String[])new String[0]) + " ")).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB())).m_7220_((Component)Component.m_237113_((String)modeString).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GREY_4.getRGB())));
            String valueString = this.instance.value != null ? this.instance.value : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value.none", (String[])new String[0]);
            this.valueComponent = Component.m_237113_((String)(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value", (String[])new String[0]) + " ")).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB())).m_7220_((Component)Component.m_237113_((String)valueString).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GREY_4.getRGB())));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 3 + 6);
        }

        @Override
        public void render(PoseStack matrix, int mouseX, int mouseY, float partial) {
            super.render(matrix, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            int centerYLine3 = this.getY() + 3 + this.lineHeight / 2 * 5;
            RenderSystem.m_69478_();
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5, centerYLine1 - 2, LISTING_DOT_RED);
            float f = this.getX() + 5 + 4 + 3;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(matrix, (Component)this.displayNameComponent, f, (float)(centerYLine1 - 9 / 2), -1);
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5 + 4 + 3, centerYLine2 - 2, LISTING_DOT_BLUE);
            float f2 = this.getX() + 5 + 4 + 3 + 4 + 3;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(matrix, (Component)this.modeComponent, f2, (float)(centerYLine2 - 9 / 2), -1);
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5 + 4 + 3, centerYLine3 - 2, LISTING_DOT_BLUE);
            float f3 = this.getX() + 5 + 4 + 3 + 4 + 3;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(matrix, (Component)this.valueComponent, f3, (float)(centerYLine3 - 9 / 2), -1);
        }

        private int calculateWidth() {
            int w = 12 + this.font.m_92852_((FormattedText)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.m_92852_((FormattedText)this.modeComponent) + 5;
            int w3 = 19 + this.font.m_92852_((FormattedText)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            if (w3 > w) {
                w = w3;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }

    public static class RequirementGroupEntry
    extends TextListScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementGroup group;

        public RequirementGroupEntry(ScrollArea parent, LoadingRequirementGroup group) {
            super(parent, (Component)Component.m_237113_((String)group.identifier).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB())).m_7220_((Component)Component.m_237113_((String)(" (" + Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.group.info", (String[])new String[]{"" + group.getInstances().size()}) + ")")).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GREY_4.getRGB()))), LISTING_DOT_ORANGE, entry -> {});
            this.group = group;
            this.setHeight(this.getHeight() + 6);
        }
    }
}

