/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button.buttonactions.layout;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.konkrete.localization.Locals;
import java.util.List;

public class DisableLayoutButtonAction
extends ButtonActionContainer {
    public DisableLayoutButtonAction() {
        super("fancymenu_buttonaction_disable_layout");
    }

    @Override
    public String getAction() {
        return "disable_layout";
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(String value) {
        if (value != null) {
            List<MenuCustomizationProperties.LayoutProperties> enabled = MenuCustomizationProperties.getAsLayoutProperties(MenuCustomizationProperties.getProperties());
            for (MenuCustomizationProperties.LayoutProperties l : enabled) {
                String name;
                if (l.path == null || !(name = Files.getNameWithoutExtension((String)l.path)).equals(value)) continue;
                MenuCustomization.disableLayout(l);
                return;
            }
        }
    }

    @Override
    public String getActionDescription() {
        return Locals.localize((String)"fancymenu.helper.buttonaction.disable_layout.desc", (String[])new String[0]);
    }

    @Override
    public String getValueDescription() {
        return Locals.localize((String)"fancymenu.helper.buttonaction.disable_layout.value.desc", (String[])new String[0]);
    }

    @Override
    public String getValueExample() {
        return "my_cool_main_menu_layout";
    }
}

