/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import cy.jdkdigital.everythingcopper.common.block.entity.CopperChimeBlockEntity;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import cy.jdkdigital.everythingcopper.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopperChime
extends BellBlock
implements IWeatheringBlock {
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.m_83110_((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    public final WeatheringCopper.WeatherState weatherState;

    public CopperChime(WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = state;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(blockState);
    }

    private VoxelShape getVoxelShape(BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)f_49679_);
        BellAttachType bellattachtype = (BellAttachType)blockState.m_61143_((Property)f_49680_);
        if (bellattachtype == BellAttachType.FLOOR) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE;
        }
        if (bellattachtype == BellAttachType.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellattachtype == BellAttachType.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public boolean m_152188_(@Nullable Entity entity, Level level, BlockPos pos, Direction direction) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!level.f_46443_ && blockentity instanceof CopperChimeBlockEntity) {
            CopperChimeBlockEntity chimeBlockEntity = (CopperChimeBlockEntity)blockentity;
            if (direction == null) {
                direction = (Direction)level.m_8055_(pos).m_61143_((Property)f_49679_);
            }
            chimeBlockEntity.m_58834_(direction);
            level.m_5594_(null, pos, (SoundEvent)ModSounds.CHIME.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            level.m_142346_(entity, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return CopperChime.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.COPPER_CHIME.get()), (BlockEntityTicker)(level.f_46443_ ? BellBlockEntity::m_155175_ : CopperChimeBlockEntity::serverTick));
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        this.m_220947_(blockState, level, blockPos, random);
    }

    public boolean m_6724_(BlockState blockState) {
        return IWeatheringBlock.getNext(blockState.m_60734_()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockpos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult res = this.applyWax(blockState, level, blockpos, player, hand);
        return res.equals((Object)InteractionResult.PASS) ? super.m_6227_(blockState, level, blockpos, player, hand, hitResult) : res;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new CopperChimeBlockEntity(pos, blockState);
    }
}

