/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.container_library.CommonClient;
import ellemes.container_library.api.client.function.ScreenSizePredicate;
import ellemes.container_library.api.client.gui.AbstractScreen;
import ellemes.container_library.api.inventory.AbstractHandler;
import ellemes.container_library.client.PickButton;
import ellemes.container_library.client.gui.widget.ScreenPickButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends Screen {
    private static final Map<ResourceLocation, PickButton> BUTTON_SETTINGS = new HashMap<ResourceLocation, PickButton>();
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<Screen> returnToScreen;
    private final List<ScreenPickButton> optionButtons = new ArrayList<ScreenPickButton>(this.options.size());
    @NotNull
    private final Runnable onOptionPicked;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.m_6262_(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.m_6262_(), Minecraft.m_91087_().f_91074_.m_150109_(), currentScreen.m_96636_()), () -> {});
    }

    public PickScreen(Supplier<Screen> returnToScreen) {
        this(null, returnToScreen, () -> {});
    }

    public PickScreen(@NotNull Runnable onOptionPicked) {
        this(null, () -> null, onOptionPicked);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<Screen> returnToScreen, Runnable onOptionPicked) {
        super((Component)Component.m_237115_((String)"screen.ellemes_container_lib.screen_picker_title"));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
        this.onOptionPicked = onOptionPicked;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void declareButtonSettings(ResourceLocation type, ResourceLocation texture, Component title, ScreenSizePredicate warningTest, List<Component> warningText) {
        BUTTON_SETTINGS.putIfAbsent(type, new PickButton(texture, title, warningTest, warningText));
    }

    public void m_7379_() {
        if (this.handler != null) {
            int invSize;
            ResourceLocation preference = CommonClient.getConfigWrapper().getPreferredScreenType();
            if (AbstractScreen.getScreenSize(preference, invSize = this.handler.getInventory().m_6643_(), this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_()) == null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"generic.ellemes_container_lib.label").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"chat.ellemes_container_lib.cannot_display_screen", (Object[])new Object[]{Component.m_237115_((String)("screen." + preference.m_135827_() + "." + preference.m_135815_() + "_screen"))}).m_130940_(ChatFormatting.WHITE)), false);
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            this.handler.clearSlots();
        }
        this.f_96541_.m_91152_(this.returnToScreen.get());
    }

    public boolean m_7043_() {
        return this.f_96541_.f_91073_ == null;
    }

    protected void m_7856_() {
        int topPadding;
        super.m_7856_();
        ResourceLocation preference = CommonClient.getConfigWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Mth.m_14042_((int)this.f_96543_, (int)96), choices);
        int innerPadding = Math.min((this.f_96543_ - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.f_96543_ - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.f_96544_ - 96) / 2;
        this.optionButtons.clear();
        for (ResourceLocation option : this.options) {
            final PickButton settings = BUTTON_SETTINGS.get(option);
            final boolean isWarn = settings.getWarningTest().test(this.f_96543_, this.f_96544_);
            final boolean isCurrent = option.equals((Object)preference);
            Button.OnTooltip tooltip = new Button.OnTooltip(){
                private static final Component CURRENT_OPTION_TEXT = Component.m_237115_((String)"screen.ellemes_container_lib.current_option_notice").m_130940_(ChatFormatting.GOLD);

                public void m_93752_(Button button, PoseStack stack, int x, int y) {
                    ArrayList<Component> tooltip = new ArrayList<Component>(4);
                    tooltip.add(button.m_6035_());
                    if (isCurrent) {
                        tooltip.add(CURRENT_OPTION_TEXT);
                    }
                    if (isWarn) {
                        tooltip.addAll(settings.getWarningText());
                    }
                    PickScreen.this.m_169388_(stack, tooltip, Optional.empty(), x, y);
                }

                public void m_142753_(Consumer<Component> consumer) {
                    if (isCurrent) {
                        consumer.accept(CURRENT_OPTION_TEXT);
                    }
                    if (isWarn) {
                        MutableComponent text = Component.m_237113_((String)"");
                        for (Component component : settings.getWarningText()) {
                            text.m_7220_(component);
                        }
                        consumer.accept((Component)text);
                    }
                }
            };
            this.optionButtons.add((ScreenPickButton)this.m_142416_((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, button -> this.updatePlayerPreference(option), tooltip)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.getConfigWrapper().setPreferredScreenType(selection);
        this.onOptionPicked.run();
        this.m_7379_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, delta);
        this.optionButtons.forEach(button -> button.renderButtonTooltip(stack, mouseX, mouseY));
        GuiComponent.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)Math.max(this.topPadding / 2, 0), (int)-1);
    }
}

