/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import ellemes.container_library.CommonClient;
import ellemes.container_library.Utils;
import ellemes.container_library.api.client.function.ScreenSize;
import ellemes.container_library.api.client.gui.AbstractScreen;
import ellemes.container_library.api.client.gui.TexturedRect;
import ellemes.container_library.api.inventory.AbstractHandler;
import ellemes.container_library.client.gui.widget.PageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.jetbrains.annotations.NotNull;

@IPNGuiHint(button=IPNButton.MOVE_TO_CONTAINER, horizontalOffset=58)
public final class PageScreen
extends AbstractScreen {
    private final ResourceLocation textureLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final Set<TexturedRect> blankArea = new LinkedHashSet<TexturedRect>();
    private final int blankSlots;
    private final int pages;
    private PageButton leftPageButton;
    private PageButton rightPageButton;
    private int page;
    private MutableComponent currentPageText;
    private float pageTextX;

    public PageScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.textureLocation = Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        this.textureWidth = switch (this.inventoryWidth) {
            case 9 -> {
                if (this.inventoryHeight == 3) {
                    yield 176;
                }
                yield 208;
            }
            case 12 -> 256;
            case 15 -> 320;
            case 18 -> 368;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryWidth);
        };
        this.textureHeight = switch (this.inventoryHeight) {
            case 3 -> 192;
            case 6 -> 240;
            case 9 -> 304;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryHeight);
        };
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        this.pages = Mth.m_14165_((double)((double)this.totalSlots / (double)slotsPerPage));
        int lastPageSlots = this.totalSlots - (this.pages - 1) * slotsPerPage;
        this.blankSlots = slotsPerPage - lastPageSlots;
        this.f_97726_ = 7 + 18 * this.inventoryWidth + 7;
        this.f_97727_ = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    private static boolean regionIntersects(AbstractWidget widget, int x, int y, int width, int height) {
        return widget.f_93620_ <= x + width && y <= widget.f_93621_ + widget.m_93694_() || x <= widget.f_93620_ + widget.m_5711_() && widget.f_93621_ <= y + height;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        ArrayList<Pair<ScreenSize, ScreenSize>> options = new ArrayList<Pair<ScreenSize, ScreenSize>>();
        PageScreen.addEntry(options, slots, 9, 3);
        PageScreen.addEntry(options, slots, 9, 6);
        if (scaledHeight >= 276 && slots > 54) {
            PageScreen.addEntry(options, slots, 9, 9);
        }
        Pair<ScreenSize, ScreenSize> picked = null;
        for (Pair<ScreenSize, ScreenSize> option : options) {
            if (picked == null) {
                picked = option;
                continue;
            }
            ScreenSize pickedMeta = (ScreenSize)picked.getSecond();
            ScreenSize iterMeta = (ScreenSize)option.getSecond();
            ScreenSize iterDim = (ScreenSize)option.getFirst();
            if (pickedMeta.getHeight() == iterMeta.getHeight() && iterMeta.getWidth() < pickedMeta.getWidth()) {
                picked = option;
                continue;
            }
            if (CommonClient.getConfigWrapper().preferSmallerScreens() && pickedMeta.getWidth() == iterMeta.getWidth() + 1 && (double)iterMeta.getHeight() <= (double)(iterDim.getWidth() * iterDim.getHeight()) / 2.0 || iterMeta.getWidth() >= pickedMeta.getWidth() || !((double)iterMeta.getHeight() <= (double)(iterDim.getWidth() * iterDim.getHeight()) / 2.0)) continue;
            picked = option;
        }
        return (ScreenSize)picked.getFirst();
    }

    private static void addEntry(ArrayList<Pair<ScreenSize, ScreenSize>> options, int slots, int width, int height) {
        int pages = Mth.m_14165_((double)((double)slots / (double)(width * height)));
        int blanked = slots - pages * width * height;
        options.add((Pair<ScreenSize, ScreenSize>)new Pair((Object)ScreenSize.of(width, height), (Object)ScreenSize.of(pages, blanked)));
    }

    protected void m_7286_(PoseStack stack, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.textureWidth, (int)this.textureHeight);
        this.blankArea.forEach(image -> image.render(stack));
    }

    private void initializeSlots(Inventory playerInventory) {
        ((AbstractHandler)this.f_97732_).resetSlotPositions(true, this.inventoryWidth, this.inventoryHeight);
        int playerInvLeft = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int playerInvTop = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, playerInvLeft + 18 * x, playerInvTop + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.f_97732_).addClientSlot(new Slot((Container)playerInventory, x, playerInvLeft + 18 * x, playerInvTop + 58));
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.f_97726_ - 176) / 2)) || mouseX > (double)(left + this.f_97726_ - outsideRegion))) {
            return true;
        }
        return super.m_7467_(mouseX, mouseY, left, top, button);
    }

    private void setPage(int oldPage, int newPage) {
        if (newPage == 0 || newPage > this.pages) {
            return;
        }
        this.page = newPage;
        if (newPage > oldPage) {
            if (this.page == this.pages) {
                this.rightPageButton.setActive(false);
                if (this.blankSlots > 0) {
                    int rows = Mth.m_14042_((int)this.blankSlots, (int)this.inventoryWidth);
                    int remainder = this.blankSlots - this.inventoryWidth * rows;
                    int yTop = this.f_97736_ + 17 + (this.inventoryHeight - 1) * 18;
                    int xLeft = this.f_97735_ + 7;
                    for (int i = 0; i < rows; ++i) {
                        this.blankArea.add(new TexturedRect(xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
                        yTop -= 18;
                    }
                    if (remainder > 0) {
                        int xRight = this.f_97735_ + 7 + this.inventoryWidth * 18;
                        int width = remainder * 18;
                        this.blankArea.add(new TexturedRect(xRight - width, yTop, width, 18, 7, this.f_97727_, this.textureWidth, this.textureHeight));
                    }
                }
            }
            if (!this.leftPageButton.f_93623_) {
                this.leftPageButton.setActive(true);
            }
        } else if (newPage < oldPage) {
            if (this.page == 1) {
                this.leftPageButton.setActive(false);
            }
            this.blankArea.clear();
            if (!this.rightPageButton.f_93623_) {
                this.rightPageButton.setActive(true);
            }
        }
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        int oldMin = slotsPerPage * (oldPage - 1);
        int oldMax = Math.min(oldMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.f_97732_).moveSlotRange(oldMin, oldMax, -2000);
        int newMin = slotsPerPage * (newPage - 1);
        int newMax = Math.min(newMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.f_97732_).moveSlotRange(newMin, newMax, 2000);
        this.setPageText();
    }

    private void setPageText() {
        this.currentPageText = Component.m_237110_((String)"screen.ellemes_container_lib.page_x_y", (Object[])new Object[]{this.page, this.pages});
        this.pageTextX = (float)(this.leftPageButton.f_93620_ + this.leftPageButton.m_5711_() + this.rightPageButton.f_93620_) / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.currentPageText) / 2.0f + 0.5f;
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        this.leftPageButton.renderButtonTooltip(stack, mouseX, mouseY);
        this.rightPageButton.renderButtonTooltip(stack, mouseX, mouseY);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        int currentPage = this.page;
        if (currentPage != 1) {
            ((AbstractHandler)this.f_97732_).resetSlotPositions(false, this.inventoryWidth, this.inventoryHeight);
            super.m_6574_(client, width, height);
            this.blankArea.clear();
            this.setPage(1, currentPage);
            return;
        }
        super.m_6574_(client, width, height);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.f_96539_, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        if (this.currentPageText != null) {
            this.f_96547_.m_92877_(stack, this.currentPageText.m_7532_(), this.pageTextX - (float)this.f_97735_, (float)(this.f_97727_ - 94), 0x404040);
        }
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262 || keyCode == 267) {
            this.setPage(this.page, Screen.m_96638_() ? this.pages : this.page + 1);
            return true;
        }
        if (keyCode == 263 || keyCode == 266) {
            this.setPage(this.page, Screen.m_96638_() ? 1 : this.page - 1);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Rect2i> getExclusionZones() {
        return Collections.emptyList();
    }

    public void addPageButtons() {
        int x;
        int width = 54;
        int originalX = x = this.f_97735_ + this.f_97726_ - 61;
        int y = this.f_97736_ + this.f_97727_ - 96;
        ArrayList<AbstractWidget> renderableChildren = new ArrayList<AbstractWidget>();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)child;
            renderableChildren.add(widget);
        }
        renderableChildren.sort(Comparator.comparingInt(a -> -a.f_93620_));
        for (AbstractWidget widget : renderableChildren) {
            if (!PageScreen.regionIntersects(widget, x, y, width, 12)) continue;
            x = widget.f_93620_ - width - 2;
        }
        this.page = 1;
        if (x == originalX && CommonClient.isModLoaded("inventoryprofiles")) {
            x -= 14;
        }
        this.leftPageButton = new PageButton(x, y, 0, (Component)Component.m_237115_((String)"screen.ellemes_container_lib.prev_page"), button -> this.setPage(this.page, this.page - 1), this::renderButtonTooltip);
        this.leftPageButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.leftPageButton);
        this.rightPageButton = new PageButton(x + 42, y, 1, (Component)Component.m_237115_((String)"screen.ellemes_container_lib.next_page"), button -> this.setPage(this.page, this.page + 1), this::renderButtonTooltip);
        this.m_142416_((GuiEventListener)this.rightPageButton);
        this.setPageText();
    }

    private void renderButtonTooltip(AbstractButton button, PoseStack stack, int x, int y) {
        this.m_96602_(stack, button.m_6035_(), x, y);
    }
}

