/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.api.v3.client;

import ellemes.container_library.Utils;
import ellemes.container_library.api.client.ScreenConstructor;
import ellemes.container_library.api.client.function.ScreenSizePredicate;
import ellemes.container_library.api.client.function.ScreenSizeRetriever;
import ellemes.container_library.api.client.gui.AbstractScreen;
import ellemes.container_library.client.gui.PickScreen;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScreenTypeApi {
    private ScreenTypeApi() {
        throw new IllegalStateException("ScreenTypeApi should not be instantiated.");
    }

    public static void registerScreenButton(ResourceLocation type, ResourceLocation texture, Component title, ScreenSizePredicate warningTest, List<Component> warningText) {
        Utils.requiresNonNull(type, "type");
        Utils.requiresNonNull(texture, "texture");
        Utils.requiresNonNull(title, "title");
        Utils.requiresNonNull(warningTest, "warningTest");
        Utils.requiresNonNull(warningText, "warningText");
        PickScreen.declareButtonSettings(type, texture, title, warningTest, warningText);
    }

    public static void registerScreenButton(ResourceLocation type, ResourceLocation texture, Component title) {
        Utils.requiresNonNull(type, "type");
        Utils.requiresNonNull(texture, "texture");
        Utils.requiresNonNull(title, "title");
        PickScreen.declareButtonSettings(type, texture, title, ScreenSizePredicate::noTest, List.of());
    }

    public static void registerScreenType(ResourceLocation type, ScreenConstructor<?> screenConstructor) {
        Utils.requiresNonNull(type, "type");
        Utils.requiresNonNull(screenConstructor, "screenConstructor");
        AbstractScreen.declareScreenType(type, screenConstructor);
    }

    public static void registerDefaultScreenSize(ResourceLocation type, ScreenSizeRetriever retriever) {
        Utils.requiresNonNull(type, "type");
        Utils.requiresNonNull(retriever, "retriever");
        AbstractScreen.declareScreenSizeRetriever(type, retriever);
    }

    public static void setPrefersSingleScreen(ResourceLocation type) {
        Utils.requiresNonNull(type, "type");
        AbstractScreen.setPrefersSingleScreen(type);
    }
}

