/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.api.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import ellemes.container_library.CommonClient;
import ellemes.container_library.Utils;
import ellemes.container_library.api.client.ScreenConstructor;
import ellemes.container_library.api.client.function.ScreenSize;
import ellemes.container_library.api.client.function.ScreenSizeRetriever;
import ellemes.container_library.api.inventory.AbstractHandler;
import ellemes.container_library.client.gui.PickScreen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends AbstractContainerScreen<AbstractHandler> {
    private static final Map<ResourceLocation, ScreenConstructor<?>> SCREEN_CONSTRUCTORS = new HashMap();
    private static final Map<ResourceLocation, ScreenSizeRetriever> SIZE_RETRIEVERS = new HashMap<ResourceLocation, ScreenSizeRetriever>();
    private static final Set<ResourceLocation> PREFERS_SINGLE_SCREEN = new HashSet<ResourceLocation>();
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;

    protected AbstractScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().m_6643_();
        this.inventoryWidth = screenSize.getWidth();
        this.inventoryHeight = screenSize.getHeight();
    }

    @ApiStatus.Internal
    public static AbstractScreen createScreen(AbstractHandler handler, Inventory playerInventory, Component title) {
        ScreenSize screenSize;
        ResourceLocation forcedScreenType = handler.getForcedScreenType();
        ResourceLocation preference = forcedScreenType != null ? forcedScreenType : CommonClient.getConfigWrapper().getPreferredScreenType();
        int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int slots = handler.getInventory().m_6643_();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if ((screenSize = SIZE_RETRIEVERS.get(preference).get(slots, scaledWidth, scaledHeight)) == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        return SCREEN_CONSTRUCTORS.get(preference).createScreen(handler, playerInventory, title, screenSize);
    }

    private static boolean shouldPreferSingleScreen(ResourceLocation type) {
        return PREFERS_SINGLE_SCREEN.contains(type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void declareScreenType(ResourceLocation type, ScreenConstructor<?> screenConstructor) {
        SCREEN_CONSTRUCTORS.putIfAbsent(type, screenConstructor);
    }

    @ApiStatus.Internal
    public static void declareScreenSizeRetriever(ResourceLocation type, ScreenSizeRetriever retriever) {
        SIZE_RETRIEVERS.putIfAbsent(type, retriever);
    }

    @ApiStatus.Internal
    public static boolean isScreenTypeDeclared(ResourceLocation type) {
        return SCREEN_CONSTRUCTORS.containsKey(type);
    }

    @ApiStatus.Internal
    public static void setPrefersSingleScreen(ResourceLocation type) {
        PREFERS_SINGLE_SCREEN.add(type);
    }

    @Nullable
    @ApiStatus.Internal
    public static ScreenSize getScreenSize(ResourceLocation type, int slots, int scaledWidth, int scaledHeight) {
        return SIZE_RETRIEVERS.get(type).get(slots, scaledWidth, scaledHeight);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, delta);
        this.m_7025_(stack, mouseX, mouseY);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.f_97732_).getForcedScreenType() == null) {
            this.f_96541_.m_91152_((Screen)new PickScreen(this));
            return true;
        }
        if (keyCode == 256 || this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public abstract List<Rect2i> getExclusionZones();

    @ApiStatus.Internal
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

