/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library;

import ellemes.container_library.Utils;
import ellemes.container_library.api.inventory.AbstractHandler;
import ellemes.container_library.inventory.ClientScreenHandlerFactory;
import ellemes.container_library.wrappers.NetworkWrapper;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public final class CommonMain {
    public static final Logger LOGGER = LogManager.getLogger((String)"ellemes_container_lib");
    private static MenuType<AbstractHandler> screenHandlerType;
    private static NetworkWrapper networkWrapper;

    public static void initialize(BiFunction<ResourceLocation, ClientScreenHandlerFactory, MenuType> handlerTypeFunction, NetworkWrapper networkWrapper) {
        screenHandlerType = handlerTypeFunction.apply(Utils.HANDLER_TYPE_ID, AbstractHandler::createClientMenu);
        CommonMain.networkWrapper = networkWrapper;
    }

    public static void warnThrowableMessage(String message, Throwable throwable, Object ... values) {
        LOGGER.warn((Message)new FormattedMessage(message, values, throwable));
    }

    public static MenuType<AbstractHandler> getScreenHandlerType() {
        return screenHandlerType;
    }

    public static NetworkWrapper getNetworkWrapper() {
        return networkWrapper;
    }
}

