/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library;

import ellemes.container_library.Utils;
import ellemes.container_library.api.v2.OpenableBlockEntityProviderV2;
import ellemes.container_library.api.v3.OpenableInventoryProvider;
import ellemes.container_library.api.v3.client.ScreenOpeningApi;
import ellemes.container_library.api.v3.client.ScreenTypeApi;
import ellemes.container_library.client.KeyHandler;
import ellemes.container_library.client.gui.PageScreen;
import ellemes.container_library.client.gui.ScrollScreen;
import ellemes.container_library.client.gui.SingleScreen;
import ellemes.container_library.wrappers.ConfigWrapper;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class CommonClient {
    private static ConfigWrapper configWrapper;
    private static KeyHandler keyHandler;
    private static Function<String, Boolean> modLoadedFunction;

    public static void initialize(BiFunction<Path, Path, ConfigWrapper> configWrapperMaker, Path configPath, Path oldConfigPath, KeyHandler keyHandler, Function<String, Boolean> modLoadedFunction) {
        configWrapper = configWrapperMaker.apply(configPath, oldConfigPath);
        CommonClient.keyHandler = keyHandler;
        CommonClient.modLoadedFunction = modLoadedFunction;
        ScreenTypeApi.registerScreenButton(Utils.PAGE_SCREEN_TYPE, Utils.id("textures/gui/page_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.page_screen"));
        ScreenTypeApi.registerScreenButton(Utils.SCROLL_SCREEN_TYPE, Utils.id("textures/gui/scroll_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.scroll_screen"));
        ScreenTypeApi.registerScreenButton(Utils.SINGLE_SCREEN_TYPE, Utils.id("textures/gui/single_button.png"), (Component)Component.m_237115_((String)"screen.ellemes_container_lib.single_screen"), (scaledWidth, scaledHeight) -> scaledWidth < 370 || scaledHeight < 386, List.of(Component.m_237115_((String)"screen.ellemes_container_lib.off_screen_warning_1").m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"screen.ellemes_container_lib.off_screen_warning_2").m_130940_(ChatFormatting.GRAY)));
        ScreenTypeApi.registerScreenType(Utils.PAGE_SCREEN_TYPE, PageScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SINGLE_SCREEN_TYPE, SingleScreen::new);
        ScreenTypeApi.registerDefaultScreenSize(Utils.PAGE_SCREEN_TYPE, PageScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SINGLE_SCREEN_TYPE, SingleScreen::retrieveScreenSize);
        ScreenTypeApi.setPrefersSingleScreen(Utils.PAGE_SCREEN_TYPE);
        ScreenTypeApi.setPrefersSingleScreen(Utils.SCROLL_SCREEN_TYPE);
    }

    public static ConfigWrapper getConfigWrapper() {
        return configWrapper;
    }

    public static boolean isConfigKeyPressed(int keyCode, int scanCode, int modifiers) {
        return keyHandler.isKeyPressed(keyCode, scanCode, modifiers);
    }

    public static boolean isModLoaded(String modId) {
        return modLoadedFunction.apply(modId);
    }

    public static boolean tryOpenSpectatorInventory(ClientLevel world, Player player, HitResult hit, InteractionHand hand) {
        if (player.m_5833_()) {
            switch (hit.m_6662_()) {
                case BLOCK: {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    BlockState state = world.m_8055_(blockHit.m_82425_());
                    Block block = state.m_60734_();
                    if (block instanceof OpenableBlockEntityProviderV2) {
                        if (state.m_60664_((Level)world, player, hand, blockHit) == InteractionResult.SUCCESS) {
                            Minecraft.m_91087_().f_91072_.m_233729_(world, i -> new ServerboundUseItemOnPacket(hand, blockHit, i));
                        }
                        return true;
                    }
                    if (!(block instanceof OpenableInventoryProvider)) break;
                    ScreenOpeningApi.openBlockInventory(blockHit.m_82425_());
                    return true;
                }
                case ENTITY: {
                    Entity entity = ((EntityHitResult)hit).m_82443_();
                    if (!(entity instanceof OpenableInventoryProvider)) break;
                    ScreenOpeningApi.openEntityInventory(entity);
                    return true;
                }
            }
        }
        return false;
    }
}

