/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.pillar;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartCaseJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartWhenJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import org.jetbrains.annotations.NotNull;

public class PillarBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public PillarBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (PillarBlock pillar : ModBlocks.getInstance().getPillars()) {
            this.createBlockStateFile(cache, pillar);
        }
    }

    private void createBlockStateFile(CachedOutput cache, PillarBlock pillar) throws IOException {
        if (pillar.getRegistryName() == null) {
            return;
        }
        ArrayList cases = Lists.newArrayList();
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/pillars/" + pillar.getRegistryName().m_135815_() + "/pillar_column")), new MultipartWhenJson("column", "pillar_column")));
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/pillars/" + pillar.getRegistryName().m_135815_() + "/pillar_base")), new MultipartWhenJson("column", "pillar_base")));
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/pillars/" + pillar.getRegistryName().m_135815_() + "/pillar_capital")), new MultipartWhenJson("column", "pillar_capital")));
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/pillars/" + pillar.getRegistryName().m_135815_() + "/full_pillar")), new MultipartWhenJson("column", "full_pillar")));
        BlockstateJson blockstate = new BlockstateJson((List)cases);
        Path blockStateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockStatePath = blockStateFolder.resolve(pillar.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockStatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Shingles BlockStates Provider";
    }
}

