/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.FollowOwner2Goal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.OwnerHurtByTarget2Goal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.OwnerHurtTarget2Goal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.RabbitMeleeGoal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.Sit2Goal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Rabbit.class})
public abstract class RabbitMixin
extends Animal
implements ModifedToBeTameable,
IComandableMob {
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> f_29647_;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID;
    private static final EntityDataAccessor<Integer> COMMAND;
    private static final EntityDataAccessor<Boolean> TAMED;

    @Shadow
    public abstract int m_29719_();

    protected RabbitMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Rabbit;registerGoals()V"})
    private void di_registerGoals(CallbackInfo ci) {
        this.f_21345_.m_25352_(1, (Goal)new Sit2Goal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwner2Goal(this, 2.0, 10.0f, 3.0f, false));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTarget2Goal(this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTarget2Goal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_}), false));
        if (this.isTame()) {
            this.removeUntamedGoals();
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Rabbit;defineSynchedData()V"})
    private void di_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Rabbit;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.m_128405_("DICommand", this.getCommand());
        compoundNBT.m_128379_("Tamed", this.isTame());
        if (this.getTameOwnerUUID() != null) {
            compoundNBT.m_128362_("Owner", this.getTameOwnerUUID());
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Rabbit;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        UUID uuid;
        this.setCommand(compoundNBT.m_128451_("DICommand"));
        this.setTame(compoundNBT.m_128471_("Tamed"));
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setTameOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int i) {
        this.f_19804_.m_135381_(COMMAND, (Object)i);
    }

    @Override
    public boolean isTame() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    @Override
    public void setTame(boolean b) {
        this.f_19804_.m_135381_(TAMED, (Object)b);
        if (b) {
            this.removeUntamedGoals();
        }
    }

    @Override
    @Nullable
    public UUID getTameOwnerUUID() {
        return (Boolean)DomesticationMod.CONFIG.tameableRabbit.get() != false ? ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null) : null;
    }

    @Override
    public void setTameOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public LivingEntity getTameOwner() {
        try {
            UUID uuid = this.getTameOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public boolean isFollowingOwner() {
        return this.getCommand() == 2 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isStayingStill() {
        return this.getCommand() == 1 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isValidAttackTarget(LivingEntity target) {
        return this.m_29719_() == 99 && (!this.isTame() || !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)target));
    }

    public void removeUntamedGoals() {
        try {
            this.f_21345_.m_148105_().stream().filter(wrapped -> wrapped.m_26015_() instanceof AvoidEntityGoal).filter(WrappedGoal::m_7620_).forEach(WrappedGoal::m_8041_);
            this.f_21345_.m_148105_().removeIf(wrapped -> wrapped.m_26015_() instanceof AvoidEntityGoal);
            this.f_21346_.m_148105_().removeIf(wrapped -> wrapped.m_26015_() instanceof NearestAttackableTargetGoal);
        }
        catch (Exception e) {
            DomesticationMod.LOGGER.warn("encountered error modifying rabbit AI");
        }
    }

    @Inject(at={@At(value="HEAD")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Rabbit;setRabbitType(I)V"}, cancellable=true)
    private void di_setRabbitType(int type, CallbackInfo ci) {
        ci.cancel();
        if (type == 99) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(8.0);
            this.m_5634_(22.0f);
            this.f_21345_.m_25352_(4, (Goal)new RabbitMeleeGoal(this));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
            if (!this.isTame()) {
                this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
                this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
            } else {
                this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTarget2Goal(this));
                this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTarget2Goal(this));
                this.removeUntamedGoals();
            }
            if (!this.m_8077_()) {
                this.m_6593_((Component)Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)new ResourceLocation("killer_bunny"))));
            }
        }
        this.f_19804_.m_135381_(f_29647_, (Object)type);
    }

    public void sendCommandMessage(Player owner, int command, Component name) {
        owner.m_5661_((Component)Component.m_237110_((String)("message.domesticationinnovation.command_" + command), (Object[])new Object[]{name}), true);
    }

    static {
        OWNER_UUID = SynchedEntityData.m_135353_(Rabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        COMMAND = SynchedEntityData.m_135353_(Rabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TAMED = SynchedEntityData.m_135353_(Rabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

