/*
 * Decompiled with CFR 0.152.
 */
package net.perpetualeve.deeppouches.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.perpetualeve.deeppouches.network.DPConfigSyncPacket;
import net.perpetualeve.deeppouches.network.DPPacket;

public class DPPacketManager {
    public static final DPPacketManager MANAGER = new DPPacketManager();
    public SimpleChannel channel;
    final String version = "1.0.0";

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("deeppouches"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);
        this.registerPacket(1, DPConfigSyncPacket.class, DPConfigSyncPacket::new);
    }

    public <T extends DPPacket> void registerPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.channel.registerMessage(index, packet, this::writePacket, K -> this.readPacket((FriendlyByteBuf)K, creator), this::handlePacket);
    }

    protected void writePacket(DPPacket packet, FriendlyByteBuf buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends DPPacket> T readPacket(FriendlyByteBuf buffer, Supplier<T> values) {
        try {
            DPPacket packet = (DPPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(DPPacket packet, Supplier<NetworkEvent.Context> provider) {
        try {
            NetworkEvent.Context context = provider.get();
            Player player = this.getPlayer(context);
            context.enqueueWork(() -> packet.handlePacket(player));
            context.setPacketHandled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Player getPlayer(NetworkEvent.Context cont) {
        ServerPlayer entity = cont.getSender();
        return entity != null ? entity : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public void sendToServer(DPPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public void sendToPlayer(DPPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
    }

    public void sendToAllPlayers(DPPacket packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void sendToAllDim(Level level, DPPacket packet) {
        this.channel.send(PacketDistributor.DIMENSION.with(() -> level.m_46472_()), (Object)packet);
    }

    public void sendToAllChunkWatchers(LevelChunk chunk, DPPacket packet) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)packet);
    }

    public void sendToAllEntityWatchers(Entity entity, DPPacket packet) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)packet);
    }

    public void sendToNearby(Level level, BlockPos pos, int radius, DPPacket packet) {
        this.sendToNearby(new PacketDistributor.TargetPoint((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)radius, level.m_46472_()), packet);
    }

    public void sendToNearby(PacketDistributor.TargetPoint point, DPPacket packet) {
        this.channel.send(PacketDistributor.NEAR.with(() -> point), (Object)packet);
    }
}

